/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.launcher.VmsCommandLauncher;

public class ExtendedExecutor
extends DefaultExecutor {
    private final boolean inheritIo;

    public ExtendedExecutor(boolean inheritIo) {
        this.inheritIo = inheritIo;
    }

    protected Process launch(CommandLine command, Map<String, String> env, Path workingDirectory) throws IOException {
        return this.launch(command, env, workingDirectory.toFile());
    }

    protected Process launch(CommandLine command, Map<String, String> env, File dir) throws IOException {
        if (dir != null && !dir.exists()) {
            throw new IOException(dir + " doesn't exist.");
        }
        if (OS.isFamilyOpenVms()) {
            return new VmsCommandLauncher().exec(command, env, dir);
        }
        ProcessBuilder pb = new ProcessBuilder(command.toStrings());
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey() != null ? entry.getKey() : "";
            String val = entry.getValue() != null ? entry.getValue() : "";
            pb.environment().put(key, val);
        }
        pb.directory(dir);
        if (this.inheritIo) {
            pb.inheritIO();
        }
        return pb.start();
    }
}

