/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.curl;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.codelibs.curl.Curl;
import org.codelibs.curl.CurlException;
import org.codelibs.curl.CurlResponse;
import org.codelibs.curl.io.ContentCache;
import org.codelibs.curl.io.ContentOutputStream;

public class CurlRequest {
    protected static final String GZIP = "gzip";
    protected static final Logger logger = Logger.getLogger(CurlRequest.class.getName());
    protected String url;
    protected Proxy proxy;
    protected String encoding = "UTF-8";
    protected int threshold = 0x100000;
    protected Curl.Method method;
    protected List<String> paramList;
    protected List<String[]> headerList;
    protected String body;
    protected InputStream bodyStream;
    protected String compression = null;
    protected SSLSocketFactory sslSocketFactory = null;
    protected ForkJoinPool threadPool;
    private BiConsumer<CurlRequest, HttpURLConnection> connectionBuilder;

    public CurlRequest(Curl.Method method, String url) {
        this.method = method;
        this.url = url;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public String encoding() {
        return this.encoding;
    }

    public int threshold() {
        return this.threshold;
    }

    public Curl.Method method() {
        return this.method;
    }

    public String body() {
        return this.body;
    }

    public CurlRequest proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public CurlRequest encoding(String encoding) {
        if (this.paramList != null) {
            throw new CurlException("This method must be called before param method.");
        }
        this.encoding = encoding;
        return this;
    }

    public CurlRequest threshold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    public CurlRequest gzip() {
        return this.compression(GZIP);
    }

    public CurlRequest compression(String compression) {
        this.compression = compression;
        return this;
    }

    public CurlRequest sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public CurlRequest body(String body) {
        if (this.bodyStream != null) {
            throw new CurlException("body method is already called.");
        }
        this.body = body;
        return this;
    }

    public CurlRequest body(InputStream stream) {
        if (this.body != null) {
            throw new CurlException("body method is already called.");
        }
        this.bodyStream = stream;
        return this;
    }

    public CurlRequest onConnect(BiConsumer<CurlRequest, HttpURLConnection> connectionBuilder) {
        this.connectionBuilder = connectionBuilder;
        return this;
    }

    public CurlRequest param(String key, String value) {
        if (value == null) {
            return this;
        }
        if (this.paramList == null) {
            this.paramList = new ArrayList<String>();
        }
        this.paramList.add(this.encode(key) + "=" + this.encode(value));
        return this;
    }

    public CurlRequest header(String key, String value) {
        if (this.headerList == null) {
            this.headerList = new ArrayList<String[]>();
        }
        this.headerList.add(new String[]{key, value});
        return this;
    }

    public void connect(Consumer<HttpURLConnection> actionListener, Consumer<Exception> exceptionListener) {
        Runnable task = () -> {
            if (this.paramList != null) {
                int sp = this.url.indexOf(63) == -1 ? 63 : 38;
                StringBuilder urlBuf = new StringBuilder(100);
                for (String param : this.paramList) {
                    urlBuf.append((char)sp).append(param);
                    if (sp != 63) continue;
                    sp = 38;
                }
                this.url = this.url + urlBuf.toString();
            }
            HttpURLConnection connection = null;
            try {
                logger.fine(() -> ">>> " + (Object)((Object)this.method) + " " + this.url);
                URL u = new URL(this.url);
                connection = this.open(u);
                connection.setRequestMethod(this.method.toString());
                if (this.headerList != null) {
                    for (String[] values : this.headerList) {
                        logger.fine(() -> ">>> " + values[0] + "=" + values[1]);
                        connection.addRequestProperty(values[0], values[1]);
                    }
                }
                if (this.compression != null) {
                    connection.setRequestProperty("Accept-Encoding", this.compression);
                }
                if (this.connectionBuilder != null) {
                    this.connectionBuilder.accept(this, connection);
                }
                if (this.body != null) {
                    logger.fine(() -> ">>> " + this.body);
                    connection.setDoOutput(true);
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), this.encoding));){
                        writer.write(this.body);
                        writer.flush();
                    }
                }
                if (this.bodyStream != null) {
                    logger.fine(() -> ">>> <binary>");
                    connection.setDoOutput(true);
                    try (OutputStream out = connection.getOutputStream();){
                        IOUtils.copy((InputStream)this.bodyStream, (OutputStream)out);
                        out.flush();
                    }
                }
                actionListener.accept(connection);
            }
            catch (Exception e) {
                exceptionListener.accept(new CurlException("Failed to access to " + this.url, e));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        };
        if (this.threadPool != null) {
            this.threadPool.execute(task);
        } else {
            task.run();
        }
    }

    protected HttpURLConnection open(URL u) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)(this.proxy != null ? u.openConnection(this.proxy) : u.openConnection());
        if (this.sslSocketFactory != null && connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
        }
        return connection;
    }

    public void execute(Consumer<CurlResponse> actionListener, Consumer<Exception> exceptionListener) {
        this.connect(con -> {
            RequestProcessor processor = new RequestProcessor(this.encoding, this.threshold);
            processor.accept((HttpURLConnection)con);
            try (CurlResponse res = processor.getResponse();){
                actionListener.accept(res);
            }
            catch (IOException e) {
                exceptionListener.accept(e);
            }
        }, exceptionListener);
    }

    public CurlResponse execute() {
        this.threadPool = null;
        RequestProcessor processor = new RequestProcessor(this.encoding, this.threshold);
        this.connect(processor, e -> {
            throw new CurlException("Failed to process a request.", (Throwable)e);
        });
        return processor.getResponse();
    }

    protected String encode(String value) {
        try {
            return URLEncoder.encode(value, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new CurlException("Invalid encoding: " + this.encoding, e);
        }
    }

    public CurlRequest threadPool(ForkJoinPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public static class RequestProcessor
    implements Consumer<HttpURLConnection> {
        protected CurlResponse response = new CurlResponse();
        private final String encoding;
        private int threshold;

        public RequestProcessor(String encoding, int threshold) {
            this.encoding = encoding;
            this.threshold = threshold;
        }

        public CurlResponse getResponse() {
            return this.response;
        }

        @Override
        public void accept(HttpURLConnection con) {
            try {
                this.response.setEncoding(this.encoding);
                this.response.setHttpStatusCode(con.getResponseCode());
                this.response.setHeaders(con.getHeaderFields());
            }
            catch (Exception e) {
                throw new CurlException("Failed to access the response.", e);
            }
            this.writeContent(() -> {
                try {
                    if (con.getResponseCode() < 400) {
                        if (CurlRequest.GZIP.equals(con.getContentEncoding())) {
                            return new GZIPInputStream(con.getInputStream());
                        }
                        return con.getInputStream();
                    }
                    if ("head".equalsIgnoreCase(con.getRequestMethod())) {
                        return new ByteArrayInputStream(new byte[0]);
                    }
                    if (CurlRequest.GZIP.equals(con.getContentEncoding())) {
                        return new GZIPInputStream(con.getErrorStream());
                    }
                    return con.getErrorStream();
                }
                catch (IOException e) {
                    throw new CurlException("Failed to process a request.", e);
                }
            });
        }

        private void writeContent(Supplier<InputStream> handler) {
            try (BufferedInputStream bis = new BufferedInputStream(handler.get());
                 ContentOutputStream dfos = new ContentOutputStream(this.threshold, Curl.tmpDir);){
                byte[] bytes = new byte[4096];
                int length = bis.read(bytes);
                while (length != -1) {
                    if (length != 0) {
                        int len = length;
                        logger.fine(() -> {
                            try {
                                return "<<< " + new String(bytes, 0, len, this.encoding);
                            }
                            catch (Exception e) {
                                return "<<< <" + e.getMessage() + ">";
                            }
                        });
                        dfos.write(bytes, 0, length);
                    }
                    length = bis.read(bytes);
                }
                dfos.flush();
                logger.fine(() -> "Response in " + (dfos.isInMemory() ? "Memory" : "File"));
                ContentCache contentCache = dfos.isInMemory() ? new ContentCache(dfos.getData()) : new ContentCache(dfos.getFile());
                this.response.setContentCache(contentCache);
            }
            catch (Exception e) {
                this.response.setContentException(e);
                throw new CurlException("Failed to write a response.", e);
            }
        }
    }
}

