/*
 * Decompiled with CFR 0.152.
 */
package org.jline.curses.impl;

import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jline.curses.Component;
import org.jline.curses.Constraint;
import org.jline.curses.Curses;
import org.jline.curses.Position;
import org.jline.curses.Size;
import org.jline.curses.impl.AbstractPanel;

public class BorderPanel
extends AbstractPanel {
    @Override
    public void addComponent(Component component, Constraint constraint) {
        if (!(constraint instanceof Curses.Location)) {
            throw new IllegalArgumentException("Constraint should be a Location: " + constraint);
        }
        if (this.components.containsValue(constraint)) {
            throw new IllegalArgumentException("Two components have the same location: " + constraint);
        }
        super.addComponent(component, constraint);
    }

    @Override
    protected Size doGetPreferredSize() {
        EnumMap<Curses.Location, Integer> w = new EnumMap<Curses.Location, Integer>(Curses.Location.class);
        EnumMap<Curses.Location, Integer> h = new EnumMap<Curses.Location, Integer>(Curses.Location.class);
        this.preferred(w, h);
        int pw = BorderPanel.max((Integer)w.get(Curses.Location.Top), (Integer)w.get(Curses.Location.Left) + (Integer)w.get(Curses.Location.Center) + (Integer)w.get(Curses.Location.Right), (Integer)w.get(Curses.Location.Bottom));
        int ph = (Integer)h.get(Curses.Location.Top) + BorderPanel.max((Integer)h.get(Curses.Location.Left), (Integer)h.get(Curses.Location.Center), (Integer)h.get(Curses.Location.Right)) + (Integer)h.get(Curses.Location.Bottom);
        return new Size(pw, ph);
    }

    @Override
    protected void layout() {
        Size size = this.getSize();
        EnumMap<Curses.Location, Integer> x = new EnumMap<Curses.Location, Integer>(Curses.Location.class);
        EnumMap<Curses.Location, Integer> y = new EnumMap<Curses.Location, Integer>(Curses.Location.class);
        EnumMap<Curses.Location, Integer> w = new EnumMap<Curses.Location, Integer>(Curses.Location.class);
        EnumMap<Curses.Location, Integer> h = new EnumMap<Curses.Location, Integer>(Curses.Location.class);
        this.preferred(w, h);
        this.fit(h, size.h(), Curses.Location.Center, Curses.Location.Top, Curses.Location.Bottom);
        this.fit(w, size.w(), Curses.Location.Center, Curses.Location.Left, Curses.Location.Right);
        w.put(Curses.Location.Top, size.w());
        w.put(Curses.Location.Bottom, size.w());
        h.put(Curses.Location.Left, (Integer)h.get(Curses.Location.Center));
        h.put(Curses.Location.Right, (Integer)h.get(Curses.Location.Center));
        this.pos(x, w, Curses.Location.Left, Curses.Location.Center, Curses.Location.Right);
        this.pos(y, h, Curses.Location.Top, Curses.Location.Center, Curses.Location.Bottom);
        x.put(Curses.Location.Top, 0);
        x.put(Curses.Location.Bottom, 0);
        y.put(Curses.Location.Left, (Integer)y.get(Curses.Location.Center));
        y.put(Curses.Location.Right, (Integer)y.get(Curses.Location.Center));
        for (Map.Entry entry : this.components.entrySet()) {
            Component c = (Component)entry.getKey();
            Curses.Location l = (Curses.Location)entry.getValue();
            c.setPosition(new Position((Integer)x.get(l), (Integer)y.get(l)));
            c.setSize(new Size((Integer)w.get(l), (Integer)h.get(l)));
        }
    }

    private void pos(Map<Curses.Location, Integer> p, Map<Curses.Location, Integer> s, Curses.Location ... locs) {
        int c = 0;
        for (Curses.Location loc : locs) {
            p.put(loc, c);
            c += s.getOrDefault(loc, 0).intValue();
        }
    }

    private void fit(Map<Curses.Location, Integer> h, int max, Curses.Location ... locs) {
        int diff = Stream.of(locs).map(l -> h.getOrDefault(l, 0)).mapToInt(Integer::intValue).sum() - max;
        if (diff < 0) {
            h.put(locs[0], h.get(locs[0]) - diff);
        } else {
            int idx = locs.length - 1;
            while (diff > 0) {
                int l2 = h.get(locs[idx]);
                int nb = Math.min(diff, l2);
                h.put(locs[idx], l2 - nb);
                diff -= nb;
                --idx;
            }
        }
    }

    private void preferred(Map<Curses.Location, Integer> w, Map<Curses.Location, Integer> h) {
        for (Curses.Location l : Curses.Location.values()) {
            w.put(l, 0);
            h.put(l, 0);
        }
        for (Map.Entry entry : this.components.entrySet()) {
            Curses.Location l = (Curses.Location)entry.getValue();
            Size s = ((Component)entry.getKey()).getPreferredSize();
            w.put(l, s.w());
            h.put(l, s.h());
        }
    }

    private static int max(int i0, int i1, int i2) {
        return Math.max(i0, Math.max(i1, i2));
    }
}

