/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.secure_sm.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.opensearch.secure_sm.policy.GrantEntry;
import org.opensearch.secure_sm.policy.PermissionEntry;
import org.opensearch.secure_sm.policy.PolicyInitializationException;
import org.opensearch.secure_sm.policy.PolicyParser;

public class PolicyFile
extends Policy {
    public static final Set<String> PERM_CLASSES_TO_SKIP = Set.of("org.opensearch.secure_sm.ThreadContextPermission", "org.opensearch.secure_sm.ThreadPermission", "org.opensearch.SpecialPermission", "org.bouncycastle.crypto.CryptoServicesPermission", "org.opensearch.script.ClassPermission", "javax.security.auth.AuthPermission", "javax.security.auth.kerberos.ServicePermission", "com.sun.tools.attach.AttachPermission");
    private final PolicyInfo policyInfo;
    private final URL url;

    public PolicyFile(URL url) {
        this.url = url;
        try {
            this.policyInfo = this.init(url);
        }
        catch (PolicyInitializationException e) {
            throw new RuntimeException("Failed to initialize policy file", e);
        }
    }

    private PolicyInfo init(URL policy) throws PolicyInitializationException {
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        try (InputStreamReader reader = new InputStreamReader(PolicyFile.getInputStream(policy), StandardCharsets.UTF_8);){
            List<GrantEntry> grantEntries = PolicyParser.read(reader);
            for (GrantEntry grantEntry : grantEntries) {
                this.addGrantEntry(grantEntry, entries);
            }
        }
        catch (Exception e) {
            throw new PolicyInitializationException("Failed to load policy from: " + String.valueOf(policy), e);
        }
        return new PolicyInfo(entries);
    }

    public static InputStream getInputStream(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String path = url.getFile().replace('/', File.separatorChar);
            path = URLDecoder.decode(path, StandardCharsets.UTF_8);
            return new FileInputStream(path);
        }
        return url.openStream();
    }

    private CodeSource getCodeSource(GrantEntry grantEntry) throws PolicyInitializationException {
        try {
            Certificate[] certs = null;
            URL location = grantEntry.codeBase() != null ? PolicyFile.newURL(grantEntry.codeBase()) : null;
            return this.canonicalizeCodebase(new CodeSource(location, certs));
        }
        catch (Exception e) {
            throw new PolicyInitializationException("Failed to get CodeSource", e);
        }
    }

    private void addGrantEntry(GrantEntry grantEntry, List<PolicyEntry> entries) throws PolicyInitializationException {
        CodeSource codesource = this.getCodeSource(grantEntry);
        if (codesource == null) {
            throw new PolicyInitializationException("Null CodeSource for: " + grantEntry.codeBase());
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (PermissionEntry pe : grantEntry.permissionEntries()) {
            PermissionEntry expandedEntry = PolicyFile.expandPermissionName(pe);
            try {
                Optional<Permission> perm = PolicyFile.getInstance(expandedEntry.permission(), expandedEntry.name(), expandedEntry.action());
                perm.ifPresent(permissions::add);
            }
            catch (ClassNotFoundException e) {
                if (PERM_CLASSES_TO_SKIP.contains(pe.permission())) continue;
                throw new PolicyInitializationException("Permission class not found: " + pe.permission(), e);
            }
        }
        entries.add(new PolicyEntry(codesource, permissions));
    }

    private static PermissionEntry expandPermissionName(PermissionEntry pe) {
        int e;
        int b;
        if (pe.name() == null || !pe.name().contains("${{")) {
            return pe;
        }
        int startIndex = 0;
        StringBuilder sb = new StringBuilder();
        while ((b = pe.name().indexOf("${{", startIndex)) != -1 && (e = pe.name().indexOf("}}", b)) != -1) {
            sb.append(pe.name(), startIndex, b);
            String value = pe.name().substring(b + 3, e);
            sb.append("${{").append(value).append("}}");
            startIndex = e + 2;
        }
        sb.append(pe.name().substring(startIndex));
        return new PermissionEntry(pe.permission(), sb.toString(), pe.action());
    }

    private static final Optional<Permission> getInstance(String type, String name, String actions) throws ClassNotFoundException {
        Class<?> pc = Class.forName(type, false, null);
        Permission answer = PolicyFile.getKnownPermission(pc, name, actions);
        return Optional.ofNullable(answer);
    }

    private static Permission getKnownPermission(Class<?> claz, String name, String actions) {
        if (claz.equals(FilePermission.class)) {
            return new FilePermission(name, actions);
        }
        if (claz.equals(SocketPermission.class)) {
            return new SocketPermission(name, actions);
        }
        if (claz.equals(RuntimePermission.class)) {
            return new RuntimePermission(name, actions);
        }
        if (claz.equals(PropertyPermission.class)) {
            return new PropertyPermission(name, actions);
        }
        if (claz.equals(NetPermission.class)) {
            return new NetPermission(name, actions);
        }
        if (claz.equals(AllPermission.class)) {
            return new AllPermission();
        }
        if (claz.equals(SecurityPermission.class)) {
            return new SecurityPermission(name, actions);
        }
        return null;
    }

    @Override
    public void refresh() {
        try {
            this.init(this.url);
        }
        catch (PolicyInitializationException e) {
            throw new RuntimeException("Failed to refresh policy", e);
        }
    }

    @Override
    public boolean implies(ProtectionDomain pd, Permission p) {
        if (pd == null || p == null) {
            return false;
        }
        PermissionCollection pc = this.policyInfo.getOrCompute(pd, this::getPermissions);
        return pc != null && pc.implies(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Permissions perms = new Permissions();
        if (domain == null) {
            return perms;
        }
        try {
            this.getPermissionsForProtectionDomain(perms, domain);
        }
        catch (PolicyInitializationException e) {
            throw new RuntimeException("Failed to get permissions for domain", e);
        }
        PermissionCollection pc = domain.getPermissions();
        if (pc != null) {
            PermissionCollection permissionCollection = pc;
            synchronized (permissionCollection) {
                Enumeration<Permission> e = pc.elements();
                while (e.hasMoreElements()) {
                    perms.add(e.nextElement());
                }
            }
        }
        return perms;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        CodeSource canonicalCodeSource;
        if (codesource == null) {
            return new Permissions();
        }
        Permissions perms = new Permissions();
        try {
            canonicalCodeSource = this.canonicalizeCodebase(codesource);
        }
        catch (PolicyInitializationException e) {
            throw new RuntimeException("Failed to canonicalize CodeSource", e);
        }
        for (PolicyEntry entry : this.policyInfo.policyEntries) {
            if (!entry.codeSource().implies(canonicalCodeSource)) continue;
            for (Permission permission : entry.permissions) {
                perms.add(permission);
            }
        }
        return perms;
    }

    private void getPermissionsForProtectionDomain(Permissions perms, ProtectionDomain pd) throws PolicyInitializationException {
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return;
        }
        CodeSource canonicalCodeSource = this.canonicalizeCodebase(cs);
        for (PolicyEntry entry : this.policyInfo.policyEntries) {
            if (!entry.codeSource().implies(canonicalCodeSource)) continue;
            for (Permission permission : entry.permissions) {
                perms.add(permission);
            }
        }
    }

    private CodeSource canonicalizeCodebase(CodeSource cs) throws PolicyInitializationException {
        URL location = cs.getLocation();
        if (location == null) {
            return cs;
        }
        try {
            URL canonicalUrl = this.canonicalizeUrl(location);
            return new CodeSource(canonicalUrl, cs.getCertificates());
        }
        catch (IOException e) {
            throw new PolicyInitializationException("Failed to canonicalize CodeSource", e);
        }
    }

    private URL canonicalizeUrl(URL url) throws IOException {
        String spec;
        int separator;
        String protocol = url.getProtocol();
        if ("jar".equals(protocol) && (separator = (spec = url.getFile()).indexOf("!/")) != -1) {
            try {
                url = new URL(spec.substring(0, separator));
            }
            catch (MalformedURLException e) {
                throw new IOException("Malformed nested jar URL", e);
            }
        }
        if ("file".equals(url.getProtocol())) {
            String path = url.getPath();
            path = this.canonicalizePath(path);
            return new File(path).toURI().toURL();
        }
        return url;
    }

    private String canonicalizePath(String path) throws IOException {
        if (path.endsWith("*")) {
            path = path.substring(0, path.length() - 1);
            return new File(path).getCanonicalPath() + "*";
        }
        return new File(path).getCanonicalPath();
    }

    private static URL newURL(String spec) throws MalformedURLException, URISyntaxException {
        return new URI(spec).toURL();
    }

    private static class PolicyInfo {
        private final List<PolicyEntry> policyEntries;
        private final Map<ProtectionDomain, PermissionCollection> pdMapping;

        PolicyInfo(List<PolicyEntry> entries) {
            this.policyEntries = List.copyOf(entries);
            this.pdMapping = new ConcurrentHashMap<ProtectionDomain, PermissionCollection>();
        }

        public PermissionCollection getOrCompute(ProtectionDomain pd, Function<ProtectionDomain, PermissionCollection> computeFn) {
            return this.pdMapping.computeIfAbsent(pd, k -> (PermissionCollection)computeFn.apply((ProtectionDomain)k));
        }
    }

    private record PolicyEntry(CodeSource codeSource, List<Permission> permissions) {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{").append(this.codeSource).append("\n");
            for (Permission p : this.permissions) {
                sb.append("  ").append(p).append("\n");
            }
            sb.append("}\n");
            return sb.toString();
        }
    }
}

