/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.kafka;

import java.util.List;
import org.springframework.boot.autoconfigure.kafka.KafkaConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.kafka.KafkaContainer;

class ApacheKafkaContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<KafkaContainer, KafkaConnectionDetails> {
    ApacheKafkaContainerConnectionDetailsFactory() {
    }

    @Override
    protected KafkaConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<KafkaContainer> source) {
        return new ApacheKafkaContainerConnectionDetails(source);
    }

    private static final class ApacheKafkaContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<KafkaContainer>
    implements KafkaConnectionDetails {
        private ApacheKafkaContainerConnectionDetails(ContainerConnectionSource<KafkaContainer> source) {
            super(source);
        }

        public List<String> getBootstrapServers() {
            return List.of(((KafkaContainer)this.getContainer()).getBootstrapServers());
        }

        @Override
        public SslBundle getSslBundle() {
            return super.getSslBundle();
        }

        public String getSecurityProtocol() {
            return this.getSslBundle() != null ? "SSL" : "PLAINTEXT";
        }
    }
}

