/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.KotlinLambdaToFunctionAutoConfiguration;
import org.springframework.core.KotlinDetector;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class FunctionRegistration<T>
implements BeanNameAware {
    public static String REGISTRATION_NAME_SUFFIX = "_registration";
    private final Set<String> names = new LinkedHashSet<String>();
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private T target;
    private Type type;
    private Object userFunction;

    public FunctionRegistration(T target, String ... names) {
        Assert.notNull(target, (String)"'target' must not be null");
        this.target = target;
        this.names(names);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public void setNames(Set<String> names) {
        this.names.clear();
        this.names.addAll(names);
    }

    public Type getType() {
        return this.type;
    }

    public T getTarget() {
        return this.target;
    }

    public FunctionRegistration<T> properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public FunctionRegistration<T> type(Type type) {
        this.type = type;
        if (KotlinDetector.isKotlinPresent() && this.target instanceof KotlinLambdaToFunctionAutoConfiguration.KotlinFunctionWrapper) {
            return this;
        }
        Type discoveredFunctionType = type;
        if (discoveredFunctionType == null) {
            return null;
        }
        Class<?> inputType = FunctionTypeUtils.getRawType(FunctionTypeUtils.getInputType(discoveredFunctionType));
        Class<?> outputType = FunctionTypeUtils.getRawType(FunctionTypeUtils.getOutputType(discoveredFunctionType));
        if (inputType != null && inputType != Object.class && outputType != null && outputType != Object.class) {
            Assert.isTrue((inputType.isAssignableFrom(FunctionTypeUtils.getRawType(FunctionTypeUtils.getInputType(type))) && outputType.isAssignableFrom(FunctionTypeUtils.getRawType(FunctionTypeUtils.getOutputType(type))) ? 1 : 0) != 0, (String)("Discovered function type does not match provided function type. Discovered: " + discoveredFunctionType + "; Provided: " + type));
        } else if (inputType == null && outputType != Object.class) {
            Assert.isTrue((boolean)outputType.isAssignableFrom(FunctionTypeUtils.getRawType(FunctionTypeUtils.getOutputType(type))), (String)("Discovered function type does not match provided function type. Discovered: " + discoveredFunctionType + "; Provided: " + type));
        } else if (outputType == null && inputType != Object.class) {
            Assert.isTrue((boolean)inputType.isAssignableFrom(FunctionTypeUtils.getRawType(FunctionTypeUtils.getInputType(type))), (String)("Discovered function type does not match provided function type. Discovered: " + discoveredFunctionType + "; Provided: " + type));
        }
        return this;
    }

    public FunctionRegistration<T> target(T target) {
        this.target = target;
        return this;
    }

    public FunctionRegistration<T> name(String name) {
        return this.names(name);
    }

    public FunctionRegistration<T> names(Collection<String> names) {
        this.names.addAll(names);
        return this;
    }

    public FunctionRegistration<T> names(String ... names) {
        return this.names(Arrays.asList(names));
    }

    public void setBeanName(String name) {
        if (CollectionUtils.isEmpty(this.names)) {
            this.name(name);
        }
    }

    public Object getUserFunction() {
        return this.userFunction;
    }

    public void setUserFunction(Object userFunction) {
        this.userFunction = userFunction;
    }
}

