/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.query;

import java.util.Iterator;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

public class SpelQueryCreator
extends AbstractQueryCreator<KeyValueQuery<SpelExpression>, String> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final SpelExpression expression;

    public SpelQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
        this.expression = this.toPredicateExpression(tree);
    }

    protected String create(Part part, Iterator<Object> iterator) {
        return "";
    }

    protected String and(Part part, String base, Iterator<Object> iterator) {
        return "";
    }

    protected String or(String base, String criteria) {
        return "";
    }

    protected KeyValueQuery<SpelExpression> complete(String criteria, Sort sort) {
        KeyValueQuery<SpelExpression> query = new KeyValueQuery<SpelExpression>(this.expression);
        if (sort.isSorted()) {
            query.orderBy(sort);
        }
        return query;
    }

    protected SpelExpression toPredicateExpression(PartTree tree) {
        int parameterIndex = 0;
        StringBuilder sb = new StringBuilder();
        Iterator orPartIter = tree.iterator();
        while (orPartIter.hasNext()) {
            int partCnt = 0;
            StringBuilder partBuilder = new StringBuilder();
            PartTree.OrPart orPart = (PartTree.OrPart)orPartIter.next();
            Iterator partIter = orPart.iterator();
            while (partIter.hasNext()) {
                Part part = (Part)partIter.next();
                if (!SpelQueryCreator.requiresInverseLookup(part)) {
                    partBuilder.append("#it?.");
                    partBuilder.append(part.getProperty().toDotPath().replace(".", "?."));
                }
                if (!part.shouldIgnoreCase().equals((Object)Part.IgnoreCaseType.NEVER)) {
                    throw new InvalidDataAccessApiUsageException("Ignore case not supported");
                }
                switch (part.getType()) {
                    case TRUE: {
                        partBuilder.append("?.equals(true)");
                        break;
                    }
                    case FALSE: {
                        partBuilder.append("?.equals(false)");
                        break;
                    }
                    case SIMPLE_PROPERTY: 
                    case NEGATING_SIMPLE_PROPERTY: {
                        partBuilder.append("?.equals(").append("[").append(parameterIndex++).append("])");
                        if (part.getType() != Part.Type.NEGATING_SIMPLE_PROPERTY) break;
                        partBuilder.append(" == false");
                        break;
                    }
                    case IS_NULL: {
                        partBuilder.append(" == null");
                        break;
                    }
                    case IS_NOT_NULL: {
                        partBuilder.append(" != null");
                        break;
                    }
                    case LIKE: 
                    case NOT_LIKE: {
                        partBuilder.append("?.contains(").append("[").append(parameterIndex++).append("])");
                        if (part.getType() != Part.Type.NOT_LIKE) break;
                        partBuilder.append(" == false");
                        break;
                    }
                    case STARTING_WITH: {
                        partBuilder.append("?.startsWith(").append("[").append(parameterIndex++).append("])");
                        break;
                    }
                    case AFTER: 
                    case GREATER_THAN: {
                        partBuilder.append(">").append("[").append(parameterIndex++).append("]");
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        partBuilder.append(">=").append("[").append(parameterIndex++).append("]");
                        break;
                    }
                    case BEFORE: 
                    case LESS_THAN: {
                        partBuilder.append("<").append("[").append(parameterIndex++).append("]");
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        partBuilder.append("<=").append("[").append(parameterIndex++).append("]");
                        break;
                    }
                    case ENDING_WITH: {
                        partBuilder.append("?.endsWith(").append("[").append(parameterIndex++).append("])");
                        break;
                    }
                    case BETWEEN: {
                        int index = partBuilder.lastIndexOf("#it?.");
                        partBuilder.insert(index, "(");
                        partBuilder.append(">").append("[").append(parameterIndex++).append("]");
                        partBuilder.append("&&");
                        partBuilder.append("#it?.");
                        partBuilder.append(part.getProperty().toDotPath().replace(".", "?."));
                        partBuilder.append("<").append("[").append(parameterIndex++).append("]");
                        partBuilder.append(")");
                        break;
                    }
                    case REGEX: {
                        partBuilder.append(" matches ").append("[").append(parameterIndex++).append("]");
                        break;
                    }
                    case NOT_IN: 
                    case IN: {
                        partBuilder.append("[").append(parameterIndex++).append("].contains(");
                        partBuilder.append("#it?.");
                        partBuilder.append(part.getProperty().toDotPath().replace(".", "?."));
                        partBuilder.append(")");
                        if (part.getType() != Part.Type.NOT_IN) break;
                        partBuilder.append(" == false");
                        break;
                    }
                    default: {
                        throw new InvalidDataAccessApiUsageException("Found invalid part '%s' in query".formatted(part.getType()));
                    }
                }
                if (partIter.hasNext()) {
                    partBuilder.append(" && ");
                }
                ++partCnt;
            }
            if (partCnt > 1) {
                sb.append("(").append((CharSequence)partBuilder).append(")");
            } else {
                sb.append((CharSequence)partBuilder);
            }
            if (!orPartIter.hasNext()) continue;
            sb.append(" || ");
        }
        return StringUtils.hasText((CharSequence)sb) ? PARSER.parseRaw(sb.toString()) : PARSER.parseRaw("true");
    }

    private static boolean requiresInverseLookup(Part part) {
        return part.getType() == Part.Type.IN || part.getType() == Part.Type.NOT_IN;
    }
}

