/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.k3s;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.TextNode;
import org.testcontainers.shaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.testcontainers.utility.DockerImageName;

public class K3sContainer
extends GenericContainer<K3sContainer> {
    public static int KUBE_SECURE_PORT = 6443;
    public static int RANCHER_WEBHOOK_PORT = 8443;
    private String kubeConfigYaml;

    public K3sContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DockerImageName.parse((String)"rancher/k3s")});
        this.addExposedPorts(new int[]{KUBE_SECURE_PORT, RANCHER_WEBHOOK_PORT});
        this.setPrivilegedMode(true);
        this.withCreateContainerCmdModifier(it -> it.getHostConfig().withCgroupnsMode("host"));
        this.addFileSystemBind("/sys/fs/cgroup", "/sys/fs/cgroup", BindMode.READ_WRITE);
        HashMap<String, String> tmpFsMapping = new HashMap<String, String>();
        tmpFsMapping.put("/run", "");
        tmpFsMapping.put("/var/run", "");
        this.setTmpFsMapping(tmpFsMapping);
        this.setCommand(new String[]{"server", "--disable=traefik", "--tls-san=" + this.getHost()});
        this.setWaitStrategy((WaitStrategy)Wait.forLogMessage((String)".*Node controller sync successful.*", (int)1));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        String rawKubeConfig = (String)this.copyFileFromContainer("/etc/rancher/k3s/k3s.yaml", is -> IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
        String serverUrl = "https://" + this.getHost() + ":" + this.getMappedPort(KUBE_SECURE_PORT);
        this.kubeConfigYaml = this.kubeConfigWithServerUrl(rawKubeConfig, serverUrl);
    }

    public String getKubeConfigYaml() {
        return this.kubeConfigYaml;
    }

    public String generateInternalKubeConfigYaml(String networkAlias) {
        if (this.getNetworkAliases().contains(networkAlias)) {
            String serverUrl = "https://" + networkAlias + ":" + KUBE_SECURE_PORT;
            return this.kubeConfigWithServerUrl(this.kubeConfigYaml, serverUrl);
        }
        throw new IllegalArgumentException(networkAlias + " is not a network alias for k3s container");
    }

    private String kubeConfigWithServerUrl(String kubeConfigYaml, String serverUrl) {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        ObjectNode kubeConfigObjectNode = (ObjectNode)objectMapper.readValue(kubeConfigYaml, ObjectNode.class);
        JsonNode clusterNode = kubeConfigObjectNode.at("/clusters/0/cluster");
        if (!clusterNode.isObject()) {
            throw new IllegalStateException("'/clusters/0/cluster' expected to be an object");
        }
        ObjectNode clusterConfig = (ObjectNode)clusterNode;
        clusterConfig.replace("server", (JsonNode)new TextNode(serverUrl));
        kubeConfigObjectNode.set("current-context", (JsonNode)new TextNode("default"));
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)kubeConfigObjectNode);
    }
}

