/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xmlunit.XMLUnitException;
import org.xmlunit.diff.AbstractDifferenceEngine;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.XPathContext;
import org.xmlunit.util.Convert;
import org.xmlunit.util.DocumentBuilderFactoryConfigurer;
import org.xmlunit.util.IterableNodeList;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Mapper;
import org.xmlunit.util.Nodes;

public final class DOMDifferenceEngine
extends AbstractDifferenceEngine {
    private static final Mapper<Node, QName> QNAME_MAPPER = new Mapper<Node, QName>(){

        @Override
        public QName apply(Node n) {
            return Nodes.getQName(n);
        }
    };
    private DocumentBuilderFactory documentBuilderFactory;

    public DOMDifferenceEngine() {
        this(DocumentBuilderFactoryConfigurer.Default.configure(DocumentBuilderFactory.newInstance()));
    }

    public DOMDifferenceEngine(DocumentBuilderFactory f) {
        if (f == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.documentBuilderFactory = f;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory f) {
        if (f == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.documentBuilderFactory = f;
    }

    @Override
    public void compare(Source control, Source test) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        if (test == null) {
            throw new IllegalArgumentException("test must not be null");
        }
        try {
            Node controlNode = Convert.toNode(control, this.documentBuilderFactory);
            Node testNode = Convert.toNode(test, this.documentBuilderFactory);
            this.compareNodes(controlNode, this.xpathContextFor(controlNode), testNode, this.xpathContextFor(testNode));
        }
        catch (Exception ex) {
            throw new XMLUnitException("Caught exception during comparison", ex);
        }
    }

    private XPathContext xpathContextFor(Node n) {
        return new XPathContext(this.getNamespaceContext(), n);
    }

    AbstractDifferenceEngine.ComparisonState compareNodes(final Node control, final XPathContext controlContext, final Node test, final XPathContext testContext) {
        IterableNodeList allControlChildren = new IterableNodeList(control.getChildNodes());
        Iterable<Node> controlChildren = Linqy.filter(allControlChildren, this.getNodeFilter());
        IterableNodeList allTestChildren = new IterableNodeList(test.getChildNodes());
        Iterable<Node> testChildren = Linqy.filter(allTestChildren, this.getNodeFilter());
        return this.compare(new Comparison(ComparisonType.NODE_TYPE, controlContext, control, control.getNodeType(), testContext, test, test.getNodeType())).andThen(new Comparison(ComparisonType.NAMESPACE_URI, controlContext, control, control.getNamespaceURI(), testContext, test, test.getNamespaceURI())).andThen(new Comparison(ComparisonType.NAMESPACE_PREFIX, controlContext, control, control.getPrefix(), testContext, test, test.getPrefix())).andIfTrueThen(control.getNodeType() != 2, new Comparison(ComparisonType.CHILD_NODELIST_LENGTH, controlContext, control, Linqy.count(controlChildren), testContext, test, Linqy.count(testChildren))).andThen(new AbstractDifferenceEngine.DeferredComparison(){

            @Override
            public AbstractDifferenceEngine.ComparisonState apply() {
                return DOMDifferenceEngine.this.nodeTypeSpecificComparison(control, controlContext, test, testContext);
            }
        }).andIfTrueThen(control.getNodeType() != 2, this.compareChildren(controlContext, allControlChildren, controlChildren, testContext, allTestChildren, testChildren));
    }

    private AbstractDifferenceEngine.ComparisonState nodeTypeSpecificComparison(Node control, XPathContext controlContext, Node test, XPathContext testContext) {
        switch (control.getNodeType()) {
            case 3: 
            case 4: 
            case 8: {
                if (!(test instanceof CharacterData)) break;
                return this.compareCharacterData((CharacterData)control, controlContext, (CharacterData)test, testContext);
            }
            case 9: {
                if (!(test instanceof Document)) break;
                return this.compareDocuments((Document)control, controlContext, (Document)test, testContext);
            }
            case 1: {
                if (!(test instanceof Element)) break;
                return this.compareElements((Element)control, controlContext, (Element)test, testContext);
            }
            case 7: {
                if (!(test instanceof ProcessingInstruction)) break;
                return this.compareProcessingInstructions((ProcessingInstruction)control, controlContext, (ProcessingInstruction)test, testContext);
            }
            case 10: {
                if (!(test instanceof DocumentType)) break;
                return this.compareDocTypes((DocumentType)control, controlContext, (DocumentType)test, testContext);
            }
            case 2: {
                if (!(test instanceof Attr)) break;
                return this.compareAttributes((Attr)control, controlContext, (Attr)test, testContext);
            }
        }
        return new AbstractDifferenceEngine.OngoingComparisonState();
    }

    private AbstractDifferenceEngine.DeferredComparison compareChildren(final XPathContext controlContext, final Iterable<Node> allControlChildren, final Iterable<Node> controlChildren, final XPathContext testContext, final Iterable<Node> allTestChildren, final Iterable<Node> testChildren) {
        return new AbstractDifferenceEngine.DeferredComparison(){

            @Override
            public AbstractDifferenceEngine.ComparisonState apply() {
                controlContext.setChildren(Linqy.map(allControlChildren, ElementSelectors.TO_NODE_INFO));
                testContext.setChildren(Linqy.map(allTestChildren, ElementSelectors.TO_NODE_INFO));
                return DOMDifferenceEngine.this.compareNodeLists(allControlChildren, controlChildren, controlContext, allTestChildren, testChildren, testContext);
            }
        };
    }

    private AbstractDifferenceEngine.ComparisonState compareCharacterData(CharacterData control, XPathContext controlContext, CharacterData test, XPathContext testContext) {
        return this.compare(new Comparison(ComparisonType.TEXT_VALUE, controlContext, control, control.getData(), testContext, test, test.getData()));
    }

    private AbstractDifferenceEngine.ComparisonState compareDocuments(Document control, final XPathContext controlContext, Document test, final XPathContext testContext) {
        final DocumentType controlDt = this.filterNode(control.getDoctype());
        final DocumentType testDt = this.filterNode(test.getDoctype());
        return this.compare(new Comparison(ComparisonType.HAS_DOCTYPE_DECLARATION, controlContext, control, controlDt != null, testContext, test, testDt != null)).andIfTrueThen(controlDt != null && testDt != null, new AbstractDifferenceEngine.DeferredComparison(){

            @Override
            public AbstractDifferenceEngine.ComparisonState apply() {
                return DOMDifferenceEngine.this.compareNodes(controlDt, controlContext, testDt, testContext);
            }
        }).andThen(this.compareDeclarations(control, controlContext, test, testContext));
    }

    private <T extends Node> T filterNode(T n) {
        return n != null && this.getNodeFilter().test(n) ? (T)n : null;
    }

    private AbstractDifferenceEngine.ComparisonState compareDocTypes(DocumentType control, XPathContext controlContext, DocumentType test, XPathContext testContext) {
        return this.compare(new Comparison(ComparisonType.DOCTYPE_NAME, controlContext, control, control.getName(), testContext, test, test.getName())).andThen(new Comparison(ComparisonType.DOCTYPE_PUBLIC_ID, controlContext, control, control.getPublicId(), testContext, test, test.getPublicId())).andThen(new Comparison(ComparisonType.DOCTYPE_SYSTEM_ID, control, null, control.getSystemId(), null, test, null, test.getSystemId(), null));
    }

    private AbstractDifferenceEngine.DeferredComparison compareDeclarations(final Document control, final XPathContext controlContext, final Document test, final XPathContext testContext) {
        return new AbstractDifferenceEngine.DeferredComparison(){

            @Override
            public AbstractDifferenceEngine.ComparisonState apply() {
                return DOMDifferenceEngine.this.compare(new Comparison(ComparisonType.XML_VERSION, controlContext, control, control.getXmlVersion(), testContext, test, test.getXmlVersion())).andThen(new Comparison(ComparisonType.XML_STANDALONE, controlContext, control, control.getXmlStandalone(), testContext, test, test.getXmlStandalone())).andThen(new Comparison(ComparisonType.XML_ENCODING, controlContext, control, control.getXmlEncoding(), testContext, test, test.getXmlEncoding()));
            }
        };
    }

    private AbstractDifferenceEngine.ComparisonState compareElements(final Element control, final XPathContext controlContext, final Element test, final XPathContext testContext) {
        return this.compare(new Comparison(ComparisonType.ELEMENT_TAG_NAME, controlContext, control, Nodes.getQName(control).getLocalPart(), testContext, test, Nodes.getQName(test).getLocalPart())).andThen(new AbstractDifferenceEngine.DeferredComparison(){

            @Override
            public AbstractDifferenceEngine.ComparisonState apply() {
                return DOMDifferenceEngine.this.compareElementAttributes(control, controlContext, test, testContext);
            }
        });
    }

    private AbstractDifferenceEngine.ComparisonState compareElementAttributes(Element control, final XPathContext controlContext, Element test, final XPathContext testContext) {
        final Attributes controlAttributes = this.splitAttributes(control.getAttributes());
        controlContext.addAttributes(Linqy.map(controlAttributes.remainingAttributes, QNAME_MAPPER));
        final Attributes testAttributes = this.splitAttributes(test.getAttributes());
        testContext.addAttributes(Linqy.map(testAttributes.remainingAttributes, QNAME_MAPPER));
        return this.compare(new Comparison(ComparisonType.ELEMENT_NUM_ATTRIBUTES, controlContext, control, controlAttributes.remainingAttributes.size(), testContext, test, testAttributes.remainingAttributes.size())).andThen(new AbstractDifferenceEngine.DeferredComparison(){

            @Override
            public AbstractDifferenceEngine.ComparisonState apply() {
                return DOMDifferenceEngine.this.compareXsiType(controlAttributes.type, controlContext, testAttributes.type, testContext);
            }
        }).andThen(new Comparison(ComparisonType.SCHEMA_LOCATION, controlContext, control, controlAttributes.schemaLocation != null ? controlAttributes.schemaLocation.getValue() : null, testContext, test, testAttributes.schemaLocation != null ? testAttributes.schemaLocation.getValue() : null)).andThen(new Comparison(ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, controlContext, control, controlAttributes.noNamespaceSchemaLocation != null ? controlAttributes.noNamespaceSchemaLocation.getValue() : null, testContext, test, testAttributes.noNamespaceSchemaLocation != null ? testAttributes.noNamespaceSchemaLocation.getValue() : null)).andThen(new NormalAttributeComparer(control, controlContext, controlAttributes, test, testContext, testAttributes));
    }

    private AbstractDifferenceEngine.ComparisonState compareProcessingInstructions(ProcessingInstruction control, XPathContext controlContext, ProcessingInstruction test, XPathContext testContext) {
        return this.compare(new Comparison(ComparisonType.PROCESSING_INSTRUCTION_TARGET, controlContext, control, control.getTarget(), testContext, test, test.getTarget())).andThen(new Comparison(ComparisonType.PROCESSING_INSTRUCTION_DATA, controlContext, control, control.getData(), testContext, test, test.getData()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDifferenceEngine.ComparisonState compareNodeLists(Iterable<Node> allControlChildren, Iterable<Node> controlSeq, final XPathContext controlContext, Iterable<Node> allTestChildren, Iterable<Node> testSeq, final XPathContext testContext) {
        AbstractDifferenceEngine.ComparisonState chain = new AbstractDifferenceEngine.OngoingComparisonState();
        Iterable<Map.Entry<Node, Node>> matches = this.getNodeMatcher().match(controlSeq, testSeq);
        List<Node> controlList = Linqy.asList(controlSeq);
        List<Node> testList = Linqy.asList(testSeq);
        Map<Node, Integer> controlListForXpathIndex = DOMDifferenceEngine.index(allControlChildren);
        Map<Node, Integer> testListForXpathIndex = DOMDifferenceEngine.index(allTestChildren);
        Map<Node, Integer> controlListIndex = DOMDifferenceEngine.index(controlList);
        Map<Node, Integer> testListIndex = DOMDifferenceEngine.index(testList);
        HashSet<Node> seen = new HashSet<Node>();
        for (Map.Entry<Node, Node> pair : matches) {
            final Node control = pair.getKey();
            seen.add(control);
            final Node test = pair.getValue();
            seen.add(test);
            Integer controlIndexForXpath = controlListForXpathIndex.get(control);
            Integer testIndexForXpath = testListForXpathIndex.get(test);
            Integer controlIndex = controlListIndex.get(control);
            Integer testIndex = testListIndex.get(test);
            if (controlIndexForXpath == null || testIndexForXpath == null || controlIndex == null || testIndex == null) {
                throw new NullPointerException("failed to look up index for pair " + pair);
            }
            controlContext.navigateToChild(controlIndexForXpath);
            testContext.navigateToChild(testIndexForXpath);
            try {
                chain = chain.andThen(new Comparison(ComparisonType.CHILD_NODELIST_SEQUENCE, controlContext, control, (int)controlIndex, testContext, test, (int)testIndex)).andThen(new AbstractDifferenceEngine.DeferredComparison(){

                    @Override
                    public AbstractDifferenceEngine.ComparisonState apply() {
                        return DOMDifferenceEngine.this.compareNodes(control, controlContext, test, testContext);
                    }
                });
            }
            finally {
                testContext.navigateToParent();
                controlContext.navigateToParent();
            }
        }
        return chain.andThen(new UnmatchedControlNodes(controlListForXpathIndex, controlList, controlContext, seen, testContext)).andThen(new UnmatchedTestNodes(testListForXpathIndex, testList, testContext, seen, controlContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDifferenceEngine.ComparisonState compareXsiType(Attr controlAttr, XPathContext controlContext, Attr testAttr, XPathContext testContext) {
        boolean mustChangeTestContext;
        boolean mustChangeControlContext = controlAttr != null;
        boolean bl = mustChangeTestContext = testAttr != null;
        if (!mustChangeControlContext && !mustChangeTestContext) {
            return new AbstractDifferenceEngine.OngoingComparisonState();
        }
        boolean attributePresentOnBothSides = mustChangeControlContext && mustChangeTestContext;
        try {
            QName controlAttrName = null;
            if (mustChangeControlContext) {
                controlAttrName = Nodes.getQName(controlAttr);
                controlContext.addAttribute(controlAttrName);
                controlContext.navigateToAttribute(controlAttrName);
            }
            QName testAttrName = null;
            if (mustChangeTestContext) {
                testAttrName = Nodes.getQName(testAttr);
                testContext.addAttribute(testAttrName);
                testContext.navigateToAttribute(testAttrName);
            }
            AbstractDifferenceEngine.ComparisonState comparisonState = this.compare(new Comparison(ComparisonType.ATTR_NAME_LOOKUP, controlContext, controlAttr, controlAttrName, testContext, testAttr, testAttrName)).andIfTrueThen(attributePresentOnBothSides, this.compareAttributeExplicitness(controlAttr, controlContext, testAttr, testContext)).andIfTrueThen(attributePresentOnBothSides, new Comparison(ComparisonType.ATTR_VALUE, controlContext, controlAttr, DOMDifferenceEngine.valueAsQName(controlAttr), testContext, testAttr, DOMDifferenceEngine.valueAsQName(testAttr)));
            return comparisonState;
        }
        finally {
            if (mustChangeControlContext) {
                controlContext.navigateToParent();
            }
            if (mustChangeTestContext) {
                testContext.navigateToParent();
            }
        }
    }

    private AbstractDifferenceEngine.ComparisonState compareAttributes(Attr control, XPathContext controlContext, Attr test, XPathContext testContext) {
        return this.compareAttributeExplicitness(control, controlContext, test, testContext).apply().andThen(new Comparison(ComparisonType.ATTR_VALUE, controlContext, control, control.getValue(), testContext, test, test.getValue()));
    }

    private AbstractDifferenceEngine.DeferredComparison compareAttributeExplicitness(final Attr control, final XPathContext controlContext, final Attr test, final XPathContext testContext) {
        return new AbstractDifferenceEngine.DeferredComparison(){

            @Override
            public AbstractDifferenceEngine.ComparisonState apply() {
                return DOMDifferenceEngine.this.compare(new Comparison(ComparisonType.ATTR_VALUE_EXPLICITLY_SPECIFIED, controlContext, control, control.getSpecified(), testContext, test, test.getSpecified()));
            }
        };
    }

    private Attributes splitAttributes(NamedNodeMap map) {
        Attr sLoc = (Attr)map.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        Attr nNsLoc = (Attr)map.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        Attr type = (Attr)map.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        LinkedList<Attr> rest = new LinkedList<Attr>();
        int len = map.getLength();
        for (int i = 0; i < len; ++i) {
            Attr a = (Attr)map.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) || a == sLoc || a == nNsLoc || a == type || !this.getAttributeFilter().test(a)) continue;
            rest.add(a);
        }
        return new Attributes(sLoc, nNsLoc, type, rest);
    }

    private static QName valueAsQName(Attr attribute) {
        if (attribute == null) {
            return null;
        }
        String[] pieces = attribute.getValue().split(":");
        if (pieces.length < 2) {
            pieces = new String[]{null, pieces[0]};
        } else if (pieces.length > 2) {
            pieces = new String[]{pieces[0], attribute.getValue().substring(pieces[0].length() + 1)};
        }
        if ("".equals(pieces[0])) {
            pieces[0] = null;
        }
        return new QName(attribute.lookupNamespaceURI(pieces[0]), pieces[1]);
    }

    private static Attr findMatchingAttr(List<Attr> attrs, Attr attrToMatch) {
        boolean hasNs = attrToMatch.getNamespaceURI() != null;
        String nsToMatch = attrToMatch.getNamespaceURI();
        String nameToMatch = hasNs ? attrToMatch.getLocalName() : attrToMatch.getName();
        for (Attr a : attrs) {
            if ((hasNs || a.getNamespaceURI() != null) && (!hasNs || !nsToMatch.equals(a.getNamespaceURI())) || (!hasNs || !nameToMatch.equals(a.getLocalName())) && (hasNs || !nameToMatch.equals(a.getName()))) continue;
            return a;
        }
        return null;
    }

    private static Map<Node, Integer> index(Iterable<Node> nodes) {
        HashMap<Node, Integer> indices = new HashMap<Node, Integer>();
        int idx = 0;
        for (Node n : nodes) {
            indices.put(n, idx++);
        }
        return Collections.unmodifiableMap(indices);
    }

    private static class Attributes {
        private final Attr schemaLocation;
        private final Attr noNamespaceSchemaLocation;
        private final Attr type;
        private final List<Attr> remainingAttributes;

        private Attributes(Attr schemaLocation, Attr noNamespaceSchemaLocation, Attr type, List<Attr> remainingAttributes) {
            this.schemaLocation = schemaLocation;
            this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
            this.type = type;
            this.remainingAttributes = remainingAttributes;
        }
    }

    private class UnmatchedTestNodes
    implements AbstractDifferenceEngine.DeferredComparison {
        private final Map<Node, Integer> testListForXpathIndex;
        private final List<Node> testList;
        private final XPathContext testContext;
        private final Set<Node> seen;
        private final XPathContext controlContext;

        private UnmatchedTestNodes(Map<Node, Integer> testListForXpathIndex, List<Node> testList, XPathContext testContext, Set<Node> seen, XPathContext controlContext) {
            this.testListForXpathIndex = testListForXpathIndex;
            this.testList = testList;
            this.testContext = testContext;
            this.seen = seen;
            this.controlContext = controlContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractDifferenceEngine.ComparisonState apply() {
            AbstractDifferenceEngine.ComparisonState chain = new AbstractDifferenceEngine.OngoingComparisonState();
            int testSize = this.testList.size();
            for (int i = 0; i < testSize; ++i) {
                if (this.seen.contains(this.testList.get(i))) continue;
                this.testContext.navigateToChild(this.testListForXpathIndex.get(this.testList.get(i)));
                try {
                    chain = chain.andThen(new Comparison(ComparisonType.CHILD_LOOKUP, null, null, null, AbstractDifferenceEngine.getXPath(this.controlContext), this.testList.get(i), AbstractDifferenceEngine.getXPath(this.testContext), Nodes.getQName(this.testList.get(i)), AbstractDifferenceEngine.getParentXPath(this.testContext)));
                    continue;
                }
                finally {
                    this.testContext.navigateToParent();
                }
            }
            return chain;
        }
    }

    private class UnmatchedControlNodes
    implements AbstractDifferenceEngine.DeferredComparison {
        private final Map<Node, Integer> controlListForXpathIndex;
        private final List<Node> controlList;
        private final XPathContext controlContext;
        private final Set<Node> seen;
        private final XPathContext testContext;

        private UnmatchedControlNodes(Map<Node, Integer> controlListForXpathIndex, List<Node> controlList, XPathContext controlContext, Set<Node> seen, XPathContext testContext) {
            this.controlListForXpathIndex = controlListForXpathIndex;
            this.controlList = controlList;
            this.controlContext = controlContext;
            this.seen = seen;
            this.testContext = testContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractDifferenceEngine.ComparisonState apply() {
            AbstractDifferenceEngine.ComparisonState chain = new AbstractDifferenceEngine.OngoingComparisonState();
            int controlSize = this.controlList.size();
            for (int i = 0; i < controlSize; ++i) {
                if (this.seen.contains(this.controlList.get(i))) continue;
                this.controlContext.navigateToChild(this.controlListForXpathIndex.get(this.controlList.get(i)));
                try {
                    chain = chain.andThen(new Comparison(ComparisonType.CHILD_LOOKUP, this.controlList.get(i), AbstractDifferenceEngine.getXPath(this.controlContext), Nodes.getQName(this.controlList.get(i)), AbstractDifferenceEngine.getParentXPath(this.controlContext), null, null, null, AbstractDifferenceEngine.getXPath(this.testContext)));
                    continue;
                }
                finally {
                    this.controlContext.navigateToParent();
                }
            }
            return chain;
        }
    }

    private class ControlAttributePresentComparer
    implements AbstractDifferenceEngine.DeferredComparison {
        private final Set<Attr> foundTestAttributes;
        private final Element control;
        private final Element test;
        private final XPathContext controlContext;
        private final XPathContext testContext;
        private final Attributes testAttributes;

        private ControlAttributePresentComparer(Element control, XPathContext controlContext, Element test, XPathContext testContext, Attributes testAttributes, Set<Attr> foundTestAttributes) {
            this.control = control;
            this.controlContext = controlContext;
            this.test = test;
            this.testContext = testContext;
            this.testAttributes = testAttributes;
            this.foundTestAttributes = foundTestAttributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractDifferenceEngine.ComparisonState apply() {
            AbstractDifferenceEngine.ComparisonState chain = new AbstractDifferenceEngine.OngoingComparisonState();
            for (Attr testAttr : this.testAttributes.remainingAttributes) {
                if (this.foundTestAttributes.contains(testAttr)) continue;
                QName testAttrName = Nodes.getQName(testAttr);
                this.testContext.navigateToAttribute(testAttrName);
                try {
                    chain = chain.andThen(new Comparison(ComparisonType.ATTR_NAME_LOOKUP, this.controlContext, this.control, null, this.testContext, this.test, testAttrName));
                }
                finally {
                    this.testContext.navigateToParent();
                }
            }
            return chain;
        }
    }

    private class NormalAttributeComparer
    implements AbstractDifferenceEngine.DeferredComparison {
        private final Set<Attr> foundTestAttributes = new HashSet<Attr>();
        private final Element control;
        private final Element test;
        private final XPathContext controlContext;
        private final XPathContext testContext;
        private final Attributes controlAttributes;
        private final Attributes testAttributes;

        private NormalAttributeComparer(Element control, XPathContext controlContext, Attributes controlAttributes, Element test, XPathContext testContext, Attributes testAttributes) {
            this.control = control;
            this.controlContext = controlContext;
            this.controlAttributes = controlAttributes;
            this.test = test;
            this.testContext = testContext;
            this.testAttributes = testAttributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractDifferenceEngine.ComparisonState apply() {
            AbstractDifferenceEngine.ComparisonState chain = new AbstractDifferenceEngine.OngoingComparisonState();
            for (final Attr controlAttr : this.controlAttributes.remainingAttributes) {
                QName controlAttrName = Nodes.getQName(controlAttr);
                final Attr testAttr = DOMDifferenceEngine.findMatchingAttr(this.testAttributes.remainingAttributes, controlAttr);
                QName testAttrName = testAttr != null ? Nodes.getQName(testAttr) : null;
                this.controlContext.navigateToAttribute(controlAttrName);
                try {
                    chain = chain.andThen(new Comparison(ComparisonType.ATTR_NAME_LOOKUP, this.controlContext, this.control, controlAttrName, this.testContext, this.test, testAttrName));
                    if (testAttr == null) continue;
                    this.testContext.navigateToAttribute(testAttrName);
                    try {
                        chain = chain.andThen(new AbstractDifferenceEngine.DeferredComparison(){

                            @Override
                            public AbstractDifferenceEngine.ComparisonState apply() {
                                return DOMDifferenceEngine.this.compareNodes(controlAttr, NormalAttributeComparer.this.controlContext, testAttr, NormalAttributeComparer.this.testContext);
                            }
                        });
                        this.foundTestAttributes.add(testAttr);
                    }
                    finally {
                        this.testContext.navigateToParent();
                    }
                }
                finally {
                    this.controlContext.navigateToParent();
                }
            }
            return chain.andThen(new ControlAttributePresentComparer(this.control, this.controlContext, this.test, this.testContext, this.testAttributes, this.foundTestAttributes));
        }
    }
}

