/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.rpcv2.internal;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonValueNodeFactory;
import software.amazon.awssdk.protocols.jsoncore.internal.EmbeddedObjectJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.NullJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.NumberJsonNode;
import software.amazon.awssdk.protocols.jsoncore.internal.StringJsonNode;
import software.amazon.awssdk.thirdparty.jackson.core.JsonParser;
import software.amazon.awssdk.thirdparty.jackson.core.JsonToken;
import software.amazon.awssdk.thirdparty.jackson.dataformat.cbor.CBORParser;

@SdkInternalApi
public final class SdkRpcV2CborValueNodeFactory
implements JsonValueNodeFactory {
    public static final JsonValueNodeFactory INSTANCE = new SdkRpcV2CborValueNodeFactory();

    private SdkRpcV2CborValueNodeFactory() {
    }

    public JsonNode node(JsonParser parser, JsonToken token) throws IOException {
        if (!(parser instanceof CBORParser)) {
            return DEFAULT.node(parser, token);
        }
        switch (token) {
            case VALUE_STRING: {
                return new StringJsonNode(parser.getText());
            }
            case VALUE_FALSE: {
                return new EmbeddedObjectJsonNode((Object)false);
            }
            case VALUE_TRUE: {
                return new EmbeddedObjectJsonNode((Object)true);
            }
            case VALUE_NULL: {
                return NullJsonNode.instance();
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return this.nodeForNumber(parser, token);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return new EmbeddedObjectJsonNode(parser.getEmbeddedObject());
            }
        }
        throw new IllegalArgumentException("Unexpected JSON token - " + token);
    }

    private JsonNode nodeForNumber(JsonParser parser, JsonToken token) throws IOException {
        JsonParser.NumberType numberType = parser.getNumberType();
        switch (numberType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                Number javaNumber = parser.getNumberValue();
                return new EmbeddedObjectJsonNode((Object)javaNumber);
            }
            case BIG_DECIMAL: {
                BigDecimal bigDecimal = parser.getDecimalValue();
                return new EmbeddedObjectJsonNode((Object)bigDecimal);
            }
            case BIG_INTEGER: {
                BigInteger bigInteger = parser.getBigIntegerValue();
                return new EmbeddedObjectJsonNode((Object)bigInteger);
            }
        }
        return new NumberJsonNode(parser.getText());
    }
}

