/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.schema;

import com.datastax.bdp.graph.api.Named;
import com.datastax.bdp.graph.api.model.Schema;
import com.datastax.bdp.graph.api.schema.Configuration;
import com.datastax.bdp.graph.api.schema.EdgeLabel;
import com.datastax.bdp.graph.api.schema.EdgeLabelImpl;
import com.datastax.bdp.graph.api.schema.PropertyKey;
import com.datastax.bdp.graph.api.schema.PropertyKeyImpl;
import com.datastax.bdp.graph.api.schema.VertexLabel;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;

public class SchemaImpl {
    public static final String QM = "\"";
    public static final String NL = "\n";
    private static final String SCHEMA_PREFIX = "schema.";
    public static final String EDGE_LABEL_PREFIX = "schema.edgeLabel(";
    public static final String PROPERTY_KEY_PREFIX = "schema.propertyKey(";
    public static final String VERTEX_LABEL_PREFIX = "schema.vertexLabel(";
    private final Schema model;

    public SchemaImpl(Schema model) {
        this.model = model;
    }

    VertexLabel vertexLabel(String name) {
        return new VertexLabel(this.model, name);
    }

    EdgeLabel edgeLabel(String name) {
        return new EdgeLabel(this.model, name);
    }

    PropertyKey propertyKey(String name) {
        return new PropertyKey(this.model, name);
    }

    String describe() {
        Stream<String> propertyKeys = this.model.propertyKeys().stream().filter(it -> !this.model.isStandardIdKey((com.datastax.bdp.graph.api.model.PropertyKey)it)).map(it -> new PropertyKeyImpl(this.model, it.name()).describeCoreDefinition());
        Stream<String> metaProperties = this.model.propertyKeys().stream().filter(it -> !this.model.isStandardIdKey((com.datastax.bdp.graph.api.model.PropertyKey)it)).map(it -> new PropertyKeyImpl(this.model, it.name()).describeMetaProperties()).filter(p -> p != null);
        Stream<String> edgeLabels = this.model.edgeLabels().stream().map(it -> new EdgeLabelImpl(this.model, it.name()).describeEdgeLabel());
        Stream<String> vertexLabels = this.model.vertexLabels().stream().map(it -> this.vertexLabel(it.name()).describe());
        Stream<String> connections = this.model.edgeLabels().stream().map(it -> new EdgeLabelImpl(this.model, it.name()).describeConnections());
        return Stream.concat(Stream.concat(Stream.concat(Stream.concat(propertyKeys, metaProperties), edgeLabels), vertexLabels), connections).collect(Collectors.joining(NL));
    }

    String clear() {
        this.drop();
        return "'clear()' is deprecated and will be removed in a future release. Please use 'drop()' instead.";
    }

    void drop() {
        this.model.drop();
    }

    GraphTraversalSource traversal() {
        return this.model.traversal();
    }

    Configuration config() {
        return new Configuration(this.model.configuration());
    }

    String getEffectiveSchemaMode() {
        return this.model.getEffectiveSchemaMode();
    }

    boolean getEffectiveAllowScan() {
        return this.model.getEffectiveAllowScan();
    }

    public static String toCommaSeparatedList(Stream<? extends Named> schemaElements) {
        return schemaElements.map(element -> SchemaImpl.quote(element)).collect(Collectors.joining(", "));
    }

    public static String quote(Named schemaElement) {
        return SchemaImpl.quote(schemaElement.name());
    }

    public static String quote(String name) {
        return QM + name + QM;
    }
}

