/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.system;

import com.datastax.bdp.graph.api.model.system.GraphSystem;
import com.datastax.bdp.graph.api.system.GraphBuilder;
import com.datastax.bdp.graph.api.system.GraphBuilderImpl;

public class GraphSystemImpl {
    private final GraphSystem system;

    public GraphSystemImpl(GraphSystem system) {
        this.system = system;
    }

    Iterable<String> graphs() {
        return this.system.getGraphs();
    }

    String describe() {
        StringBuilder s = new StringBuilder();
        for (String g : this.system.getGraphs()) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(GraphBuilderImpl.describe(g));
        }
        return s.toString();
    }

    GraphBuilder graph(String graphName) {
        return new GraphBuilder(this.system, graphName);
    }
}

