/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.model;



/**
 * Tokens to use in the readonly representation of the schema as stored in a TinkerGraph
 */
public final class SchemaTokens
{
    private SchemaTokens() {}

    /**
     * The cardinality of a property key. Single or Multiple
     */
    public static final String P_CARDINALITY = "cardinality";

    /**
     * The java data type of the property key
     */
    public static final String P_DATA_TYPE = "dataType";

    /**
     * Denotes direction. In, Out or Both
     */
    public static final String P_DIRECTIONALITY = "directionality";

    /**
     * The mode of the schema Development or Production.
     */
    public static final String P_MODE = "mode";

    /**
     * The name of the schema element.
     */
    public static final String P_NAME = "name";

    /**
     * The TTL of the schema element.
     */
    public static final String P_TTL = "ttl";

    /**
     * The type of an vertex index: Secondary, Materialized or Search
     * The type of an id column: Routing, Partition, Clustering
     * The type of index on a property: Geo, String, FullText
     */
    public static final String P_TYPE = "type";

    /**
     * An index with the unique property should return at most one result for a query.
     */
    public static final String P_UNIQUE = "unique";

    /**
     * The maximum X of a cartesian property
     */
    public static final String P_MAX_X = "maxX";

    /**
     * The maximum Y of a cartesian property
     */
    public static final String P_MAX_Y = "maxY";


    /**
     * The minimum X of a cartesian property
     */
    public static final String P_MIN_X = "minX";

    /**
     * The minimum Y of a cartesian property
     */
    public static final String P_MIN_Y = "minY";

    /**
     * The maximum distance error for a geoBounds index.
     */
    public static final String P_MAX_DIST_ERROR = "maxDistError";

    /**
     * The distance error percentage for a geoBounds index.
     */
    public static final String P_DIST_ERROR_PERCENT = "distErrorPercent";

    /**
     * Indicates that a property is used as part of the element id.
     */
    public static final String P_ID = "id";

    /**
     * A property representing a validator.
     */
    public static final String P_VALIDATOR = "validator";

    /**
     * Edge label between a vertex label and an index.
     */
    public static final String EL_INDEXES_BY = "indexesBy";

    /**
     * Edge label from an edge index indicating the edge label and adjacent vertex label that must be present for the edge to be indexed.
     * Edge label from a partition to an edge label that must match for the edge to be partitioned.
     */
    public static final String EL_MATCHES_ON = "matchesOn";

    /**
     * Edge label between labels and property keys.
     * Edge label between incident elements and edge labels.
     */
    public static final String EL_OF = "of";

    /**
     * Edge label between vertex labels and incident vertices.
     */
    public static final String EL_INCIDENT = "incident";


    /**
     * Vertex label denoting an edge label in schema.
     */
    public static final String VL_EDGE_LABEL = "edgeLabel";

    /**
     * Vertex label denoting an edge index in schema.
     */
    public static final String VL_EDGE_INDEX = "edgeIndex";

    /**
     * Vertex label denoting a property key ins schema.
     */
    public static final String VL_PROPERTY_KEY = "propertyKey";

    /**
     * Vertex label denoting a property index in schema.
     */
    public static final String VL_PROPERTY_INDEX = "propertyIndex";

    /**
     * Vertex label denoting a vertex index in schema.
     */
    public static final String VL_VERTEX_INDEX = "vertexIndex";

    /**
     * Vertex label denoting a vertex label in schema.
     */
    public static final String VL_VERTEX_LABEL = "vertexLabel";

    /**
     * Vertex label denoting an incident edge between two vertex labels.
     */
    public static final String VL_INCIDENT = "incident";

    /**
     * Vertex label denoting the root schema element.
     */
    public static final String VL_SCHEMA = "schema";

    public static final String P_ORDER = "order";

    /**
     * Engine property
     */
    public static final String P_ENGINE = "engine";

    public static final String P_SECONDARY_INDEX_FULL = "indexFull";
    public static final String P_SECONDARY_INDEX_ENTRIES = "indexEntries";
    public static final String P_SECONDARY_INDEX_VALUES = "indexValues";
    public static final String P_SECONDARY_INDEX_KEYS = "indexKeys";

}
