/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.model;

import com.datastax.bdp.graph.api.Identified;
import com.datastax.bdp.graph.api.Named;
import com.datastax.bdp.graph.api.model.Adjacency;
import com.datastax.bdp.graph.api.model.CacheConfig;
import com.datastax.bdp.graph.api.model.EdgeIndex;
import com.datastax.bdp.graph.api.model.EdgeLabel;
import com.datastax.bdp.graph.api.model.IdPropertyKey;
import com.datastax.bdp.graph.api.model.PropertyIndex;
import com.datastax.bdp.graph.api.model.PropertyKey;
import com.datastax.bdp.graph.api.model.VertexIndex;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;

public interface VertexLabel
extends Named,
Identified {
    public VertexIndex vertexIndex(String var1);

    public EdgeIndex edgeIndex(String var1);

    public PropertyIndex propertyIndex(String var1);

    public VertexIndex.Builder buildVertexIndex(String var1);

    public EdgeIndex.Builder buildEdgeIndex(String var1, String var2);

    public PropertyIndex.Builder buildPropertyIndex(String var1, String var2);

    public Set<? extends VertexIndex> vertexIndices();

    public Set<? extends EdgeIndex> edgeIndices();

    public Set<? extends PropertyIndex> propertyIndices();

    public Set<? extends PropertyKey> propertyKeys();

    public Set<? extends EdgeLabel> edgeLabels();

    public Set<? extends IdPropertyKey> idPropertyKeys();

    public Optional<Duration> ttl();

    public Set<? extends CacheConfig> cacheConfigs();

    public void setPropertyCacheTime(Duration var1);

    public void setEdgeCacheTime(Duration var1, String ... var2);

    public Set<? extends Adjacency> adjacencies();

    public void addAdjacency(String var1, Direction var2, String var3);

    default public void addAdjacency(String edgeLabel, String adjacentVertexLabel) {
        this.addAdjacency(edgeLabel, Direction.BOTH, adjacentVertexLabel);
    }

    public PropertyKey addPropertyKey(String var1);

    public boolean hasStandardId();

    public void drop();

    public void dropPropertyKey(String var1);

    public static interface Builder {
        public VertexLabel add();

        public Builder ttl(Duration var1);

        public Builder idComponent(String var1, IdPropertyKey.Type var2);

        default public Builder partitionId(String propertyKey) {
            return this.idComponent(propertyKey, IdPropertyKey.Type.Partition);
        }

        default public Builder clusteringId(String propertyKey) {
            return this.idComponent(propertyKey, IdPropertyKey.Type.Clustering);
        }

        public Builder idComponent(PropertyKey var1, IdPropertyKey.Type var2);

        public Builder addPropertyKeys(String ... var1);

        public Builder addAdjacency(String var1, Direction var2, String var3);

        default public Builder addAdjacency(String edgeLabel, String adjacentVertexLabel) {
            return this.addAdjacency(edgeLabel, Direction.BOTH, adjacentVertexLabel);
        }

        public Builder ifNotExists();
    }
}

