/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.schema;

import com.datastax.bdp.graph.api.model.config.GraphConfig;
import com.github.misberner.duzzt.annotations.DSLAction;
import com.github.misberner.duzzt.annotations.GenerateEmbeddedDSL;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * TODO
 */

@GenerateEmbeddedDSL(
        name = "Configuration",
        syntax = "(option (set | unset | get | exists)) | describe"
)
public class ConfigurationImpl
{

    private final GraphConfig config;

    private String configOption;

    ConfigurationImpl(GraphConfig config) {
        this.config = config;
    }

    @DSLAction(displayed = true)
    String describe() {
        StringBuilder s = new StringBuilder();
        int pos = 0;
        for (Map.Entry<String,Object> entry : config) {
            if (pos > 0) s.append(SchemaImpl.NL);
            s.append(entry.getKey()).append(": ").append(String.valueOf(entry.getValue()));
            pos++;
        }
        return s.toString();
    }

    @DSLAction(displayed = true)
    void option(String configOption) {
        if (StringUtils.isBlank(configOption)) throw new IllegalArgumentException("Invalid config option");
        this.configOption = configOption;
    }

    @DSLAction(displayed = true)
    void set(Object value) {
        config.set(configOption,value);
    }

    @DSLAction(displayed = true)
    void unset() {
        config.unset(configOption);
    }

    @DSLAction(displayed = true)
    Object get() {
        return config.get(configOption);
    }

    @DSLAction(displayed = true)
    boolean exists() {
        return config.contains(configOption);
    }



}
