/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.graph.api.model;

import com.datastax.bdp.graph.api.Identified;
import com.datastax.bdp.graph.api.Named;
import com.datastax.bdp.graph.api.id.SchemaId;
import com.datastax.bdp.graph.api.model.Cardinality;
import com.datastax.bdp.graph.api.model.ValueType;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface PropertyKey
extends Named,
Identified {
    @Override
    public SchemaId id();

    public ValueType dataType();

    public Optional<Duration> ttl();

    public Cardinality cardinality();

    public Set<? extends PropertyKey> propertyKeys();

    public PropertyKey addPropertyKey(String var1);

    public void dropPropertyKey(String var1);

    public void drop();

    public List<Validator<?>> validators();

    public static interface Builder {
        public Builder cardinality(Cardinality var1);

        default public Builder single() {
            return this.cardinality(Cardinality.Single);
        }

        default public Builder multiple() {
            return this.cardinality(Cardinality.Multiple);
        }

        public Builder ttl(Duration var1);

        public Builder ifNotExists();

        public PropertyKey add();

        public Builder addPropertyKeys(String ... var1);

        public Builder bounds(double var1, double var3, double var5, double var7);

        public Builder geoBounds();
    }

    public static interface Validator<T> {
        public void validate(T var1) throws IllegalArgumentException;

        public Type type();

        public String describe();

        public static enum Type {
            Bounds,
            GeoBounds;

        }
    }
}

