/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.system;

import com.datastax.bdp.graph.api.model.system.GraphSystem;
import com.datastax.bdp.graph.api.schema.SchemaImpl;
import com.github.misberner.duzzt.annotations.GenerateEmbeddedDSL;

/**
 *
 *
 * @author Matthias Broecheler (me@matthiasb.com)
 */
@GenerateEmbeddedDSL(
        name = "GraphSystem",
        syntax = "graphs|graph|describe")
public class GraphSystemImpl {

    private final GraphSystem system;

    public GraphSystemImpl(GraphSystem system) {
        this.system = system;
    }

    Iterable<String> graphs() {
        return system.getGraphs();
    }

    String describe() {
        StringBuilder s = new StringBuilder();
        for (String g : system.getGraphs()) {
            if (s.length()>0) s.append(SchemaImpl.NL);
            s.append(GraphBuilderImpl.describe(g));
        }
        return s.toString();
    }

    GraphBuilder graph(String graphName) {
        return new GraphBuilder(system, graphName);
    }


}
