/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.model;

import java.time.Duration;

/**
 * A cache configuration specifies which properties or edges on vertices of a particular label should be cached
 * and for how long.
 *
 * Created by matthias on 4/11/16.
 */
public interface CacheConfig {

    /**
     *
     * @return The source vertex label.
     */
    VertexLabel vertexLabel();

    /**
     * This method only applies if {@link #isEdgeCache()} returns true.
     *
     * @return The label for edges that are being cached - or NULL if all are cached.
     */
    EdgeLabel edgeLabel();

    /**
     *
     * @return Whether this is a cache for properties
     */
    boolean isPropertyCache();

    /**
     *
     * @return Whether this is a cache for edges
     */
    boolean isEdgeCache();

    /**
     *
     * @return The maximum duration for which properties or edges can be held in cache
     */
    Duration cacheTime();


}
