/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.model;


/**
 * A property key that is used in vertex ids.
 */
public interface IdPropertyKey extends PropertyKey
{

    /**
     * The type of the property key within a vertex' id. The type determines the position of the property key within
     * the vertex id and its locality property when placing a vertex instance in the cluster.
     */
    enum Type
    {
        /**
         * Property key is part of the routing key for a vertex instance. NOT YET SUPPORTED!
         */
        Routing,

        /**
         * Property key is part of the partition key for a vertex instance.
         */
        Partition,

        /**
         * Property key is part of the clustering key for a vertex instance.
         */
        Clustering,
    }

    /**
     *
     * @return The type of the property key.
     * @see com.datastax.bdp.graph.api.model.IdPropertyKey.Type
     */
    Type getType();

}
