/**
 * Copyright DataStax, Inc.
 *
 * Please see the included license file for details.
 */
package com.datastax.bdp.graph.api.model;

import org.apache.tinkerpop.gremlin.structure.Direction;

/**
 * Represents an adjacency on a vertex label
 */
public interface Adjacency
{

    /**
     *
     * @return The source vertex label.
     */
    VertexLabel vertexLabel();

    /**
     *
     * @return The edge label of the adjacency.
     */
    EdgeLabel edgeLabel();

    /**
     *
     * @return The destination vertex label.
     */
    VertexLabel otherLabel();

    /**
     *
     * @return The direction of the adjacency
     */
    Direction direction();
}
