/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.spark.writer;

import com.datastax.bdp.spark.writer.BulkTableWriter;
import com.datastax.bdp.spark.writer.BulkWriteConf;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.Schema;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.Nothing$;

public final class BulkTableWriter$
implements Serializable {
    public static final BulkTableWriter$ MODULE$;

    static {
        new BulkTableWriter$();
    }

    private File makeOutputDirectory(Option<Path> path, String keyspaceName, String tableName) {
        Option<Path> option;
        block4: {
            File file;
            block3: {
                block2: {
                    option = path;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Path p = (Path)some.x();
                    file = p.toFile();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                String tmpDir = System.getProperty("java.io.tmpdir");
                UUID uuid = UUID.randomUUID();
                file = new File(tmpDir, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bulk-write-to-", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyspaceName, tableName, uuid})));
            }
            return file;
        }
        throw new MatchError(option);
    }

    public <T> BulkTableWriter<T> apply(CassandraConnector connector, String keyspaceName, String tableName, ColumnSelector columnNames, BulkWriteConf writeConf, RowWriterFactory<T> evidence$1) {
        Schema schema = Schema$.MODULE$.fromCassandra(connector, (Option)new Some((Object)keyspaceName), (Option)new Some((Object)tableName));
        TableDef tableDef = (TableDef)schema.tables().headOption().getOrElse((Function0)new Serializable(keyspaceName, tableName){
            public static final long serialVersionUID = 0L;
            private final String keyspaceName$1;
            private final String tableName$1;

            public final Nothing$ apply() {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table not found: ", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.keyspaceName$1, this.tableName$1})));
            }
            {
                this.keyspaceName$1 = keyspaceName$1;
                this.tableName$1 = tableName$1;
            }
        });
        RowWriter rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(evidence$1)).rowWriter(tableDef, columnNames.selectFrom(tableDef));
        File outputDirectory = this.makeOutputDirectory(writeConf.outputDirectory(), keyspaceName, tableName);
        return new BulkTableWriter(connector, tableDef, rowWriter, outputDirectory, writeConf.deleteSource(), writeConf.bufferSizeInMB());
    }

    public <T> BulkTableWriter.BulkSaveRDDFunctions<T> BulkSaveRDDFunctions(RDD<T> rdd, RowWriterFactory<T> evidence$2) {
        return new BulkTableWriter.BulkSaveRDDFunctions<T>(rdd, evidence$2);
    }

    public <T> boolean $lessinit$greater$default$5() {
        return true;
    }

    public <T> int $lessinit$greater$default$6() {
        return 64;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BulkTableWriter$() {
        MODULE$ = this;
    }
}

