/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.CassandraRowMetadata$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraLimit;
import com.datastax.spark.connector.rdd.CassandraMergeJoinRDD$;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.ClusteringOrder;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.partitioner.NodeAddresses;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator$;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.MergeJoinIterator;
import com.datastax.spark.connector.util.NameTools$;
import com.datastax.spark.connector.util.Quote$;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.metrics.InputMetricsUpdater;
import org.apache.spark.metrics.InputMetricsUpdater$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001B\u0001\u0003\u00015\u0011QcQ1tg\u0006tGM]1NKJ<WMS8j]J#EI\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u0005AA-\u0019;bgR\f\u0007PC\u0001\f\u0003\r\u0019w.\\\u0002\u0001+\rqQ\u0006O\n\u0003\u0001=\u00012\u0001E\f\u001a\u001b\u0005\t\"BA\u0002\u0013\u0015\t91C\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<\u0017B\u0001\r\u0012\u0005\r\u0011F\t\u0012\t\u00055uyb'D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019!V\u000f\u001d7feA\u0019\u0001\u0005K\u0016\u000f\u0005\u00052cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\r\u0003\u0019a$o\\8u}%\tA$\u0003\u0002(7\u00059\u0001/Y2lC\u001e,\u0017BA\u0015+\u0005\r\u0019V-\u001d\u0006\u0003Om\u0001\"\u0001L\u0017\r\u0001\u0011)a\u0006\u0001b\u0001_\t\tA*\u0005\u00021gA\u0011!$M\u0005\u0003em\u0011qAT8uQ&tw\r\u0005\u0002\u001bi%\u0011Qg\u0007\u0002\u0004\u0003:L\bc\u0001\u0011)oA\u0011A\u0006\u000f\u0003\u0006s\u0001\u0011\ra\f\u0002\u0002%\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0002tGB\u0011QHP\u0007\u0002%%\u0011qH\u0005\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\u0006YA.\u001a4u'\u000e\fgN\u0015#E!\r\u0019EiK\u0007\u0002\u0005%\u0011QI\u0001\u0002\u0016\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197f'\u000e\fgN\u0015#E\u0011!9\u0005A!A!\u0002\u0013A\u0015\u0001\u0004:jO\"$8kY1o%\u0012#\u0005cA\"Eo!A!\n\u0001B\u0001B\u0003-1*\u0001\u0007mK\u001a$8\t\\1tgR\u000bw\rE\u0002M\u001f.j\u0011!\u0014\u0006\u0003\u001dn\tqA]3gY\u0016\u001cG/\u0003\u0002Q\u001b\nA1\t\\1tgR\u000bw\r\u0003\u0005S\u0001\t\u0005\t\u0015a\u0003T\u00035\u0011\u0018n\u001a5u\u00072\f7o\u001d+bOB\u0019AjT\u001c\t\u000bU\u0003A\u0011\u0001,\u0002\rqJg.\u001b;?)\u001196\fX/\u0015\u0007aK&\f\u0005\u0003D\u0001-:\u0004\"\u0002&U\u0001\bY\u0005\"\u0002*U\u0001\b\u0019\u0006\"B\u001eU\u0001\u0004a\u0004\"B!U\u0001\u0004\u0011\u0005\"B$U\u0001\u0004A\u0005bB\u0003\u0001\u0005\u0004%\taX\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111\rB\u0001\u0004GFd\u0017BA3c\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\t\r\u001d\u0004\u0001\u0015!\u0003a\u0003)\u0019wN\u001c8fGR|'\u000f\t\u0005\u0006S\u0002!\tA[\u0001\u0010O\u0016$\b+\u0019:uSRLwN\\&fsR!1n\u001c9z!\r\u0001\u0003\u0006\u001c\t\u0003C6L!A\u001c2\u0003\u0013\r{G.^7o\t\u00164\u0007\"B\u0003i\u0001\u0004\u0001\u0007\"B9i\u0001\u0004\u0011\u0018\u0001D6fsN\u0004\u0018mY3OC6,\u0007CA:w\u001d\tQB/\u0003\u0002v7\u00051\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)8\u0004C\u0003{Q\u0002\u0007!/A\u0005uC\ndWMT1nK\")A\u0010\u0001C\u0001{\u0006\u00192\r[3dWZ\u000bG.\u001b3NKJ<WMS8j]R\ta\u0010\u0005\u0002\u001b\u007f&\u0019\u0011\u0011A\u000e\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u000b\u0001!\u0019!C\u0001\u0003\u000f\t1\u0002V8lK:\u001cu\u000e\\;n]V\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0011\u0001\u00026bm\u0006L1a^A\u0007\u0011!\tI\u0002\u0001Q\u0001\n\u0005%\u0011\u0001\u0004+pW\u0016t7i\u001c7v[:\u0004\u0003bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\u000fi>\\WM\\#yiJ\f7\r^8s)\u0011\t\t#!\r\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005!1m\u001c:f\u0015\r\tY\u0003C\u0001\u0007IJLg/\u001a:\n\t\u0005=\u0012Q\u0005\u0002\u0006)>\\WM\u001c\u0005\t\u0003g\tY\u00021\u0001\u00026\u0005\u0019!o\\<\u0011\t\u0005\r\u0012qG\u0005\u0005\u0003s\t)CA\u0002S_^D!\"!\u0010\u0001\u0011\u000b\u0007I\u0011BA \u0003MaWM\u001a;QCJ$\u0018\u000e^5p].+\u0017p\u0015;s+\u0005\u0011\b\"CA\"\u0001!\u0005\t\u0015)\u0003s\u0003QaWM\u001a;QCJ$\u0018\u000e^5p].+\u0017p\u0015;sA!9\u0011q\t\u0001\u0005\n\u0005%\u0013\u0001\u0006;pW\u0016t'+\u00198hKR{7)\u001d7Rk\u0016\u0014\u00180\u0006\u0003\u0002L\u0005eCCBA'\u0003#\ni\u0006E\u0003\u001b;I\fy\u0005E\u0002!QMB\u0001\"a\u0015\u0002F\u0001\u0007\u0011QK\u0001\bMJ|WN\u0015#E!\u0011\u0019E)a\u0016\u0011\u00071\nI\u0006B\u0004\u0002\\\u0005\u0015#\u0019A\u0018\u0003\u0003QC\u0001\"a\u0018\u0002F\u0001\u0007\u0011\u0011M\u0001\u0006e\u0006tw-\u001a\u0019\u0007\u0003G\n\t(a\u001e\u0011\u0011\u0005\u0015\u00141NA8\u0003kj!!a\u001a\u000b\u0007\u0005%$!A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014\u0018\u0002BA7\u0003O\u0012QbQ9m)>\\WM\u001c*b]\u001e,\u0007c\u0001\u0017\u0002r\u0011Y\u00111OA/\u0003\u0003\u0005\tQ!\u00010\u0005\ryF%\r\t\u0004Y\u0005]DaCA=\u0003;\n\t\u0011!A\u0003\u0002=\u00121a\u0018\u00133\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f\nqb\u0019:fCR,7\u000b^1uK6,g\u000e\u001e\u000b\u000b\u0003\u0003\u000b9)!%\u0002\u001c\u0006u\u0005\u0003BA\u0012\u0003\u0007KA!!\"\u0002&\tI1\u000b^1uK6,g\u000e\u001e\u0005\t\u0003\u0013\u000bY\b1\u0001\u0002\f\u000691/Z:tS>t\u0007\u0003BA\u0012\u0003\u001bKA!a$\u0002&\t91+Z:tS>t\u0007\u0002CAJ\u0003w\u0002\r!!&\u0002\u0011I,\u0017\rZ\"p]\u001a\u00042aQAL\u0013\r\tIJ\u0001\u0002\t%\u0016\fGmQ8oM\"11-a\u001fA\u0002ID\u0001\"a(\u0002|\u0001\u0007\u0011\u0011U\u0001\u0007m\u0006dW/Z:\u0011\ti\t\u0019kM\u0005\u0004\u0003K[\"A\u0003\u001fsKB,\u0017\r^3e}!9\u0011\u0011\u0016\u0001\u0005\n\u0005-\u0016AE2p]Z,'\u000f\u001e*po&#XM]1u_J,B!!,\u00028RA\u0011qVA]\u0003\u007f\u000by\rE\u0003!\u0003c\u000b),C\u0002\u00024*\u0012\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004Y\u0005]FaBA.\u0003O\u0013\ra\f\u0005\t\u0003w\u000b9\u000b1\u0001\u0002>\u0006A\u0011\u000e^3sCR|'\u000fE\u0003!\u0003c\u000b)\u0004\u0003\u0005\u0002B\u0006\u001d\u0006\u0019AAb\u0003%\u0011xn\u001e*fC\u0012,'\u000f\u0005\u0004\u0002F\u0006-\u0017QW\u0007\u0003\u0003\u000fT1!!3\u0003\u0003\u0019\u0011X-\u00193fe&!\u0011QZAd\u0005%\u0011vn\u001e*fC\u0012,'\u000f\u0003\u0005\u0002R\u0006\u001d\u0006\u0019AAj\u00039\u0019w\u000e\\;n]6+G/\u0019#bi\u0006\u0004B!!6\u0002X6\tA!C\u0002\u0002Z\u0012\u0011AcQ1tg\u0006tGM]1S_^lU\r^1eCR\f\u0007bBAo\u0001\u0011%\u0011q\\\u0001\u0010M\u0016$8\r\u001b+pW\u0016t'+\u00198hKV!\u0011\u0011]Aw))\t\u0019/!:\u0002h\u0006=(\u0011\u0001\t\u00075u\t\u0019.!0\t\u0011\u0005%\u00151\u001ca\u0001\u0003\u0017C\u0001\"a\u0015\u0002\\\u0002\u0007\u0011\u0011\u001e\t\u0005\u0007\u0012\u000bY\u000fE\u0002-\u0003[$q!a\u0017\u0002\\\n\u0007q\u0006\u0003\u0005\u0002`\u0005m\u0007\u0019AAya\u0019\t\u00190a>\u0002~BA\u0011QMA6\u0003k\fY\u0010E\u0002-\u0003o$1\"!?\u0002p\u0006\u0005\t\u0011!B\u0001_\t\u0019q\fJ\u001a\u0011\u00071\ni\u0010B\u0006\u0002\u0000\u0006=\u0018\u0011!A\u0001\u0006\u0003y#aA0%i!A!1AAn\u0001\u0004\u0011)!A\nj]B,H/T3ue&\u001c7/\u00169eCR,'\u000f\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\r\u0011YAE\u0001\b[\u0016$(/[2t\u0013\u0011\u0011yA!\u0003\u0003'%s\u0007/\u001e;NKR\u0014\u0018nY:Va\u0012\fG/\u001a:\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016\u000591m\\7qkR,GC\u0002B\f\u00053\u0011\u0019\u0003\u0005\u0003!\u0003cK\u0002\u0002\u0003B\u000e\u0005#\u0001\rA!\b\u0002\u000bM\u0004H.\u001b;\u0011\u0007u\u0012y\"C\u0002\u0003\"I\u0011\u0011\u0002U1si&$\u0018n\u001c8\t\u0011\t\u0015\"\u0011\u0003a\u0001\u0005O\tqaY8oi\u0016DH\u000fE\u0002>\u0005SI1Aa\u000b\u0013\u0005-!\u0016m]6D_:$X\r\u001f;)\t\tE!q\u0006\t\u0005\u0005c\u00119$\u0004\u0002\u00034)\u0019!Q\u0007\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003:\tM\"\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007b\u0002B\u001f\u0001\u0011E#qH\u0001\u000eO\u0016$\b+\u0019:uSRLwN\\:\u0016\u0005\t\u0005\u0003#\u0002\u000e\u0003D\tu\u0011b\u0001B#7\t)\u0011I\u001d:bs\"Q!\u0011\n\u0001\t\u0006\u0004%IAa\u0013\u0002\u001b9|G-Z!eIJ,7o]3t+\t\u0011i\u0005\u0005\u0003\u0002f\t=\u0013\u0002\u0002B)\u0003O\u0012QBT8eK\u0006#GM]3tg\u0016\u001c\bB\u0003B+\u0001!\u0005\t\u0015)\u0003\u0003N\u0005qan\u001c3f\u0003\u0012$'/Z:tKN\u0004\u0003b\u0002B-\u0001\u0011\u0005#1L\u0001\u0016O\u0016$\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t)\u0011\u0011iFa\u0018\u0011\u0007\u0001B#\u000f\u0003\u0005\u0003\u001c\t]\u0003\u0019\u0001B\u000f\u0001")
public class CassandraMergeJoinRDD<L, R>
extends RDD<Tuple2<Seq<L>, Seq<R>>> {
    public final CassandraTableScanRDD<L> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD;
    public final CassandraTableScanRDD<R> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD;
    private final CassandraConnector connector;
    private final String TokenColumn;
    private String leftPartitionKeyStr;
    private NodeAddresses com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses;
    private volatile byte bitmap$0;

    private String leftPartitionKeyStr$lzycompute() {
        CassandraMergeJoinRDD cassandraMergeJoinRDD = this;
        synchronized (cassandraMergeJoinRDD) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.leftPartitionKeyStr = ((TraversableOnce)((TraversableLike)this.getPartitionKey(this.connector(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.keyspaceName(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.tableName()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ColumnDef x$4) {
                        return x$4.columnName();
                    }
                }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String name) {
                        return Quote$.MODULE$.quote(name);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.leftPartitionKeyStr;
        }
    }

    private NodeAddresses com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses$lzycompute() {
        CassandraMergeJoinRDD cassandraMergeJoinRDD = this;
        synchronized (cassandraMergeJoinRDD) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses = new NodeAddresses(this.connector());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses;
        }
    }

    public CassandraConnector connector() {
        return this.connector;
    }

    public Seq<ColumnDef> getPartitionKey(CassandraConnector connector, String keyspaceName, String tableName) {
        Option option = Schema$.MODULE$.fromCassandra(connector, (Option)new Some((Object)keyspaceName), (Option)new Some((Object)tableName)).tables().headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            TableDef table = (TableDef)some.x();
            Seq seq = table.partitionKey();
            return seq;
        }
        if (None$.MODULE$.equals(option)) {
            Metadata metadata = (Metadata)connector.withClusterDo((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Metadata apply(Cluster x$1) {
                    return x$1.getMetadata();
                }
            });
            Option suggestions = NameTools$.MODULE$.getSuggestions(metadata, keyspaceName, tableName);
            String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, tableName, suggestions);
            throw new IOException(errorMessage);
        }
        throw new MatchError((Object)option);
    }

    public void checkValidMergeJoin() {
        Seq leftPartitionKeyTypes = (Seq)this.getPartitionKey(this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.keyspaceName(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.tableName()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnType<?> apply(ColumnDef x$2) {
                return x$2.columnType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq rightPartitionKeyTypes = (Seq)this.getPartitionKey(this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.connector(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.keyspaceName(), this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.tableName()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ColumnType<?> apply(ColumnDef x$3) {
                return x$3.columnType();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq seq = leftPartitionKeyTypes;
        Seq seq2 = rightPartitionKeyTypes;
        Predef$.MODULE$.assert(!(seq != null ? !seq.equals(seq2) : seq2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition key types do not match between Right and Left RDDs in MergeJoin";
            }
        });
    }

    public String TokenColumn() {
        return this.TokenColumn;
    }

    public com.datastax.driver.core.Token tokenExtractor(Row row) {
        return row.getToken(this.TokenColumn());
    }

    private String leftPartitionKeyStr() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.leftPartitionKeyStr$lzycompute() : this.leftPartitionKeyStr;
    }

    private <T> Tuple2<String, Seq<Object>> tokenRangeToCqlQuery(CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range) {
        String columns = ((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$5) {
                return x$5.cql();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        String pk = ((TraversableOnce)fromRDD.tableDef().partitionKey().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef colDef) {
                return Quote$.MODULE$.quote(colDef.columnName());
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        Tuple2 tuple2 = range.cql(this.leftPartitionKeyStr());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String cql = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)cql, (Object)values);
            String cql2 = (String)tuple23._1();
            Seq values2 = (Seq)tuple23._2();
            String string = cql2;
            String filter = ((TraversableOnce)((TraversableLike)fromRDD.where().predicates().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$8) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
                }
            })).mkString(" AND ");
            String limitClause = (String)fromRDD.limit().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(CassandraLimit limit) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIMIT ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{limit}));
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String orderBy = (String)fromRDD.clusteringOrder().map((Function1)new Serializable(this, fromRDD){
                public static final long serialVersionUID = 0L;
                private final CassandraTableScanRDD fromRDD$1;

                public final String apply(ClusteringOrder x$9) {
                    return x$9.toCql(this.fromRDD$1.tableDef());
                }
                {
                    this.fromRDD$1 = fromRDD$1;
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            String quotedKeyspaceName = Quote$.MODULE$.quote(fromRDD.keyspaceName());
            String quotedTableName = Quote$.MODULE$.quote(fromRDD.tableName());
            String queryTemplate = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", ", TOKEN(", ") as ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns, pk, this.TokenColumn()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FROM ", ".", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedKeyspaceName, quotedTableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE ", " ", " ", " ALLOW FILTERING"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter, orderBy, limitClause}))).toString();
            Seq queryParamValues = (Seq)values2.$plus$plus((GenTraversableOnce)fromRDD.where().values(), Seq$.MODULE$.canBuildFrom());
            return new Tuple2((Object)queryTemplate, (Object)queryParamValues);
        }
        throw new MatchError((Object)tuple2);
    }

    private Statement createStatement(Session session, ReadConf readConf, String cql, Seq<Object> values) {
        try {
            PreparedStatement stmt = session.prepare(cql);
            stmt.setConsistencyLevel(readConf.consistencyLevel());
            TypeConverter[] converters = (TypeConverter[])((TraversableOnce)JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)stmt.getVariables()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TypeConverter<?> apply(ColumnDefinitions.Definition v) {
                    return ColumnType$.MODULE$.converterToCassandra(v.getType());
                }
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeConverter.class));
            Seq convertedValues = (Seq)((TraversableLike)values.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])converters), Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, TypeConverter<?>> check$ifrefutable$1) {
                    Tuple2<Object, TypeConverter<?>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(Tuple2<Object, TypeConverter<?>> x$10) {
                    Tuple2<Object, TypeConverter<?>> tuple2 = x$10;
                    if (tuple2 != null) {
                        Object value = tuple2._1();
                        TypeConverter converter = (TypeConverter)tuple2._2();
                        Object object = converter.convert(value);
                        return object;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            BoundStatement bstm = stmt.bind((Object[])convertedValues.toArray(ClassTag$.MODULE$.AnyRef()));
            bstm.setFetchSize(readConf.fetchSizeInRows());
            return bstm;
        }
        catch (Throwable throwable) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception during preparation of ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql, throwable.getMessage()})), throwable);
        }
    }

    public <T> Iterator<T> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$convertRowIterator(Iterator<Row> iterator, RowReader<T> rowReader, CassandraRowMetadata columnMetaData) {
        return iterator.map((Function1)new Serializable(this, rowReader, columnMetaData){
            public static final long serialVersionUID = 0L;
            private final RowReader rowReader$1;
            private final CassandraRowMetadata columnMetaData$1;

            public final T apply(Row row) {
                return (T)this.rowReader$1.read(row, this.columnMetaData$1);
            }
            {
                void var3_3;
                this.rowReader$1 = rowReader$1;
                this.columnMetaData$1 = var3_3;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Tuple2<CassandraRowMetadata, Iterator<Row>> com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$fetchTokenRange(Session session, CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range, InputMetricsUpdater inputMetricsUpdater) {
        Tuple2 tuple22;
        Tuple2<String, Seq<Object>> tuple2 = this.tokenRangeToCqlQuery(fromRDD, range);
        if (tuple2 == null) throw new MatchError(tuple2);
        String cql2 = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)cql2, (Object)values);
        String cql = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        this.logDebug((Function0)new Serializable(this, range, cql, values2){
            public static final long serialVersionUID = 0L;
            private final CqlTokenRange range$1;
            private final String cql$1;
            private final Seq values$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching data for range ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cql$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with params ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.values$1.mkString("[", ",", "]")}))).toString();
            }
            {
                void var4_4;
                void var3_3;
                this.range$1 = range$1;
                this.cql$1 = var3_3;
                this.values$1 = var4_4;
            }
        });
        Statement stmt = this.createStatement(session, fromRDD.readConf(), cql, (Seq<Object>)values2);
        try {
            ResultSet rs = session.execute(stmt);
            scala.collection.immutable.IndexedSeq columnNames = (scala.collection.immutable.IndexedSeq)((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(ColumnRef x$12) {
                    return x$12.selectedAs();
                }
            }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.TokenColumn()})), IndexedSeq$.MODULE$.canBuildFrom());
            CassandraRowMetadata columnMetaData = CassandraRowMetadata$.MODULE$.fromResultSet((IndexedSeq)columnNames, rs);
            PrefetchingResultSetIterator iterator = new PrefetchingResultSetIterator(rs, fromRDD.readConf().fetchSizeInRows(), PrefetchingResultSetIterator$.MODULE$.$lessinit$greater$default$3());
            Iterator iteratorWithMetrics = iterator.map((Function1)new Serializable(this, inputMetricsUpdater){
                public static final long serialVersionUID = 0L;
                private final InputMetricsUpdater inputMetricsUpdater$1;

                public final Row apply(Row row) {
                    return this.inputMetricsUpdater$1.updateMetrics(row);
                }
                {
                    this.inputMetricsUpdater$1 = inputMetricsUpdater$1;
                }
            });
            this.logDebug((Function0)new Serializable(this, range){
                public static final long serialVersionUID = 0L;
                private final CqlTokenRange range$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Row iterator for range ", " obtained successfully."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.range$1}));
                }
                {
                    this.range$1 = range$1;
                }
            });
            return new Tuple2((Object)columnMetaData, (Object)iteratorWithMetrics);
        }
        catch (Throwable throwable) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception during execution of ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cql, throwable.getMessage()})), throwable);
        }
    }

    @DeveloperApi
    public Iterator<Tuple2<Seq<L>, Seq<R>>> compute(Partition split, TaskContext context) {
        Tuple2 tuple2 = this.openSessions$1();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Session leftSession = (Session)tuple2._1();
            Session rightSession = (Session)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftSession, (Object)rightSession);
            Session leftSession2 = (Session)tuple23._1();
            Session rightSession2 = (Session)tuple23._2();
            CassandraPartition partition = (CassandraPartition)split;
            Iterable tokenRanges = partition.tokenRanges();
            boolean x$16 = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.readConf().taskMetricsEnabled() || this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.readConf().taskMetricsEnabled();
            Option x$17 = ReadConf$.MODULE$.$lessinit$greater$default$1();
            int x$18 = ReadConf$.MODULE$.$lessinit$greater$default$2();
            int x$19 = ReadConf$.MODULE$.$lessinit$greater$default$3();
            ConsistencyLevel x$20 = ReadConf$.MODULE$.$lessinit$greater$default$4();
            int x$21 = ReadConf$.MODULE$.$lessinit$greater$default$6();
            int x$22 = ReadConf$.MODULE$.$lessinit$greater$default$7();
            ReadConf metricsReadConf = new ReadConf(x$17, x$18, x$19, x$20, x$16, x$21, x$22);
            InputMetricsUpdater metricsUpdater = InputMetricsUpdater$.MODULE$.apply(context, metricsReadConf, InputMetricsUpdater$.MODULE$.apply$default$3());
            Iterator mergingIterator = tokenRanges.iterator().flatMap((Function1)new Serializable(this, leftSession2, rightSession2, metricsUpdater){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraMergeJoinRDD $outer;
                private final Session leftSession$1;
                private final Session rightSession$1;
                private final InputMetricsUpdater metricsUpdater$1;

                public final Iterator<Tuple3<com.datastax.driver.core.Token, List<L>, List<R>>> apply(CqlTokenRange<Object, Token> tokenRange) {
                    Tuple2<CassandraRowMetadata, Iterator<Row>> tuple2 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$fetchTokenRange(this.leftSession$1, this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD, tokenRange, this.metricsUpdater$1);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        CassandraRowMetadata leftMetadata = (CassandraRowMetadata)tuple2._1();
                        Iterator leftRowIterator = (Iterator)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftMetadata, (Object)leftRowIterator);
                        CassandraRowMetadata leftMetadata2 = (CassandraRowMetadata)tuple23._1();
                        Iterator leftRowIterator2 = (Iterator)tuple23._2();
                        Tuple2<CassandraRowMetadata, Iterator<Row>> tuple24 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$fetchTokenRange(this.rightSession$1, this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD, tokenRange, this.metricsUpdater$1);
                        if (tuple24 != null) {
                            Tuple2 tuple25;
                            CassandraRowMetadata rightMetadata = (CassandraRowMetadata)tuple24._1();
                            Iterator rightRowIterator = (Iterator)tuple24._2();
                            Tuple2 tuple26 = tuple25 = new Tuple2((Object)rightMetadata, (Object)rightRowIterator);
                            CassandraRowMetadata rightMetadata2 = (CassandraRowMetadata)tuple26._1();
                            Iterator rightRowIterator2 = (Iterator)tuple26._2();
                            MergeJoinIterator<L, R, K> rowMerger = new MergeJoinIterator<L, R, K>(leftRowIterator2, rightRowIterator2, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$16 $outer;

                                public final com.datastax.driver.core.Token apply(Row row) {
                                    return this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().tokenExtractor(row);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$16 $outer;

                                public final com.datastax.driver.core.Token apply(Row row) {
                                    return this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().tokenExtractor(row);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                            return rowMerger.map(new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$16 $outer;
                                private final CassandraRowMetadata leftMetadata$1;
                                private final CassandraRowMetadata rightMetadata$1;

                                public final Tuple3<com.datastax.driver.core.Token, List<L>, List<R>> apply(Tuple3<com.datastax.driver.core.Token, Seq<Row>, Seq<Row>> x0$1) {
                                    Tuple3<com.datastax.driver.core.Token, Seq<Row>, Seq<Row>> tuple3 = x0$1;
                                    if (tuple3 != null) {
                                        com.datastax.driver.core.Token t = (com.datastax.driver.core.Token)tuple3._1();
                                        Seq lRows = (Seq)tuple3._2();
                                        Seq rRows = (Seq)tuple3._3();
                                        if (t != null) {
                                            com.datastax.driver.core.Token token = t;
                                            if (lRows != null) {
                                                Seq seq = lRows;
                                                if (rRows != null) {
                                                    Seq seq2 = rRows;
                                                    Tuple3 tuple32 = new Tuple3((Object)token, (Object)this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$convertRowIterator((Iterator<Row>)seq.iterator(), this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.rowReader(), this.leftMetadata$1).toList(), (Object)this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$convertRowIterator((Iterator<Row>)seq2.iterator(), this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.rowReader(), this.rightMetadata$1).toList());
                                                    return tuple32;
                                                }
                                            }
                                        }
                                    }
                                    throw new MatchError(tuple3);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.leftMetadata$1 = leftMetadata$1;
                                    this.rightMetadata$1 = rightMetadata$1;
                                }
                            });
                        }
                        throw new MatchError(tuple24);
                    }
                    throw new MatchError(tuple2);
                }

                public /* synthetic */ CassandraMergeJoinRDD com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    void var4_4;
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.leftSession$1 = leftSession$1;
                    this.rightSession$1 = var3_3;
                    this.metricsUpdater$1 = var4_4;
                }
            });
            CountingIterator countingIterator = new CountingIterator(mergingIterator, CountingIterator$.MODULE$.$lessinit$greater$default$2());
            context.addTaskCompletionListener((Function1)new Serializable(this, leftSession2, rightSession2, partition, metricsUpdater, countingIterator){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraMergeJoinRDD $outer;
                private final Session leftSession$1;
                private final Session rightSession$1;
                public final CassandraPartition partition$1;
                private final InputMetricsUpdater metricsUpdater$1;
                public final CountingIterator countingIterator$1;

                public final void apply(TaskContext context) {
                    double duration = (double)this.metricsUpdater$1.finish() / 1.0E9;
                    this.$outer.logDebug((Function0)new Serializable(this, duration){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$compute$1 $outer;
                        private final double duration$1;

                        public final String apply() {
                            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)this.$outer.countingIterator$1.count());
                            String arg$macro$2 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.keyspaceName();
                            String arg$macro$3 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.tableName();
                            String arg$macro$4 = this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer().com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.tableName();
                            Integer arg$macro$5 = BoxesRunTime.boxToInteger((int)this.$outer.partition$1.index());
                            double arg$macro$6 = this.duration$1;
                            return new StringOps(Predef$.MODULE$.augmentString(new StringOps("Fetched %s rows from\n            |%s %s and %s\n            |for partition %s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4, arg$macro$5, BoxesRunTime.boxToDouble((double)arg$macro$6)})))).stripMargin();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.duration$1 = duration$1;
                        }
                    });
                    this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$closeSessions$1(this.leftSession$1, this.rightSession$1);
                }

                public /* synthetic */ CassandraMergeJoinRDD com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    void var6_6;
                    void var5_5;
                    void var4_4;
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.leftSession$1 = leftSession$1;
                    this.rightSession$1 = var3_3;
                    this.partition$1 = var4_4;
                    this.metricsUpdater$1 = var5_5;
                    this.countingIterator$1 = var6_6;
                }
            });
            Iterator iteratorWithoutToken = countingIterator.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<List<L>, List<R>> apply(Tuple3<com.datastax.driver.core.Token, List<L>, List<R>> tuple) {
                    return new Tuple2(tuple._2(), tuple._3());
                }
            });
            return iteratorWithoutToken;
        }
        throw new MatchError((Object)tuple2);
    }

    public Partition[] getPartitions() {
        this.checkValidMergeJoin();
        return Predef$.MODULE$.refArrayOps((Object[])this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.partitions()).size() >= Predef$.MODULE$.refArrayOps((Object[])this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.partitions()).size() ? this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.partitions() : this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.partitions();
    }

    public NodeAddresses com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses$lzycompute() : this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses;
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return ((TraversableOnce)((CassandraPartition)split).endpoints().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraMergeJoinRDD $outer;

            public final Set<String> apply(InetAddress rpcAddress) {
                return this.$outer.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$nodeAddresses().hostNames(rpcAddress);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private final Tuple2 openSessions$1() {
        Tuple2 tuple2;
        CassandraConnector cassandraConnector = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector();
        CassandraConnector cassandraConnector2 = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.connector();
        if (!(cassandraConnector != null ? !cassandraConnector.equals(cassandraConnector2) : cassandraConnector2 != null)) {
            Session session = this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector().openSession();
            tuple2 = new Tuple2((Object)session, (Object)session);
        } else {
            tuple2 = new Tuple2((Object)this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD.connector().openSession(), (Object)this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD.connector().openSession());
        }
        return tuple2;
    }

    public final void com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$closeSessions$1(Session leftSession, Session rightSession) {
        Session session = leftSession;
        Session session2 = rightSession;
        if (session == null ? session2 != null : !session.equals(session2)) {
            rightSession.close();
        }
        leftSession.close();
    }

    public CassandraMergeJoinRDD(SparkContext sc, CassandraTableScanRDD<L> leftScanRDD, CassandraTableScanRDD<R> rightScanRDD, ClassTag<L> leftClassTag, ClassTag<R> rightClassTag) {
        this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$leftScanRDD = leftScanRDD;
        this.com$datastax$spark$connector$rdd$CassandraMergeJoinRDD$$rightScanRDD = rightScanRDD;
        super(sc, (Seq)Seq$.MODULE$.empty(), ClassTag$.MODULE$.apply(Tuple2.class));
        this.connector = leftScanRDD.connector();
        this.TokenColumn = "mj_tok_col";
    }
}

