/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.pulsar.packages.management.core.MockedPackagesStorageProvider;
import org.apache.pulsar.packages.management.core.PackagesStorage;
import org.apache.pulsar.packages.management.core.PackagesStorageConfiguration;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MockedPackagesStorageTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteAndRead() throws Exception {
        MockedPackagesStorageProvider provider = new MockedPackagesStorageProvider();
        PackagesStorage storage = provider.getStorage((PackagesStorageConfiguration)Mockito.mock(PackagesStorageConfiguration.class));
        storage.initialize();
        byte[] testBytes = new byte[0x100000];
        storage.writeAsync("test/path", (InputStream)new ByteArrayInputStream(testBytes)).get();
        ByteArrayOutputStream readBaos = new ByteArrayOutputStream();
        try {
            storage.readAsync("test/path", (OutputStream)readBaos).get();
            Assert.assertEquals((byte[])readBaos.toByteArray(), (byte[])testBytes);
            storage.closeAsync().get();
        }
        finally {
            if (Collections.singletonList(readBaos).get(0) != null) {
                readBaos.close();
            }
        }
    }
}

