/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.base.Strings;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.pulsar.common.api.proto.CommandLookupTopic;
import org.apache.pulsar.common.api.proto.CommandLookupTopicResponse;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.proxy.server.DefaultLookupProxyHandler;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLRegexLookupProxyHandler
extends DefaultLookupProxyHandler {
    private static final Logger log = LoggerFactory.getLogger(URLRegexLookupProxyHandler.class);
    private Pattern pattern;
    private String replacement;

    @Override
    public void initialize(ProxyService proxy, ProxyConnection proxyConnection) {
        super.initialize(proxy, proxyConnection);
        Properties properties = proxy.getConfiguration().getProperties();
        String regex = properties.getProperty("urlRegexLookupProxyHandlerRegex");
        if (Strings.isNullOrEmpty((String)regex)) {
            throw new IllegalArgumentException("urlRegexLookupProxyHandlerRegex is not set");
        }
        this.pattern = Pattern.compile(regex);
        this.replacement = properties.getProperty("urlRegexLookupProxyHandlerReplacement");
        if (Strings.isNullOrEmpty((String)this.replacement)) {
            throw new IllegalArgumentException("urlRegexLookupProxyHandlerReplacement is not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleLookup(CommandLookupTopic lookup) {
        if (log.isDebugEnabled()) {
            log.debug("Received Lookup from {}", (Object)this.clientAddress);
        }
        long clientRequestId = lookup.getRequestId();
        if (this.lookupRequestSemaphore.tryAcquire()) {
            try {
                LOOKUP_REQUESTS.inc();
                String serviceUrl = this.getBrokerServiceUrl(clientRequestId);
                if (serviceUrl == null) return;
                if (lookup.isAuthoritative()) {
                    this.performLookup(clientRequestId, lookup.getTopic(), serviceUrl, false, 10).whenComplete((brokerUrl, ex) -> {
                        if (ex != null) {
                            ServerError serverError = ex instanceof DefaultLookupProxyHandler.LookupException ? ((DefaultLookupProxyHandler.LookupException)ex).getServerError() : this.getServerError((Throwable)ex);
                            this.proxyConnection.ctx().writeAndFlush((Object)Commands.newLookupErrorResponse((ServerError)serverError, (String)ex.getMessage(), (long)clientRequestId));
                        } else {
                            this.proxyConnection.ctx().writeAndFlush((Object)Commands.newLookupResponse((String)brokerUrl, (String)brokerUrl, (boolean)true, (CommandLookupTopicResponse.LookupType)CommandLookupTopicResponse.LookupType.Connect, (long)clientRequestId, (boolean)true));
                        }
                    });
                    return;
                }
                this.performLookup(clientRequestId, lookup.getTopic(), serviceUrl, false, 10).whenComplete((brokerUrl, ex) -> {
                    try {
                        if (this.pattern.matcher((CharSequence)brokerUrl).matches()) {
                            if (log.isDebugEnabled()) {
                                log.debug("Broker URL {} matches regex {}", brokerUrl, (Object)this.pattern);
                            }
                            String proxyUrl = this.pattern.matcher((CharSequence)brokerUrl).replaceAll(this.replacement);
                            if (log.isDebugEnabled()) {
                                log.debug("Redirect to proxy URL {}", (Object)proxyUrl);
                            }
                            this.proxyConnection.ctx().writeAndFlush((Object)Commands.newLookupResponse((String)proxyUrl, (String)proxyUrl, (boolean)true, (CommandLookupTopicResponse.LookupType)CommandLookupTopicResponse.LookupType.Redirect, (long)clientRequestId, (boolean)false));
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("Broker URL {} doesn't match regex {}", brokerUrl, (Object)this.pattern);
                            }
                            this.proxyConnection.ctx().writeAndFlush((Object)Commands.newLookupErrorResponse((ServerError)ServerError.ServiceNotReady, (String)"Broker URL does not match the lookup handler regex", (long)clientRequestId));
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        this.proxyConnection.ctx().writeAndFlush((Object)Commands.newLookupErrorResponse((ServerError)ServerError.ServiceNotReady, (String)iae.getMessage(), (long)clientRequestId));
                    }
                });
                return;
            }
            finally {
                this.lookupRequestSemaphore.release();
            }
        } else {
            REJECTED_LOOKUP_REQUESTS.inc();
            if (log.isDebugEnabled()) {
                log.debug("Lookup Request ID {} from {} rejected - {}.", new Object[]{clientRequestId, this.clientAddress, "Too many concurrent lookup and partitionsMetadata requests"});
            }
            this.proxyConnection.ctx().writeAndFlush((Object)Commands.newLookupErrorResponse((ServerError)ServerError.ServiceNotReady, (String)"Too many concurrent lookup and partitionsMetadata requests", (long)clientRequestId));
        }
    }
}

