/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.structuredeventlog.slf4j;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.structuredeventlog.Event;
import org.apache.pulsar.structuredeventlog.EventGroup;
import org.apache.pulsar.structuredeventlog.EventResources;
import org.apache.pulsar.structuredeventlog.EventResourcesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class Slf4jEvent
implements Event {
    private static final ThreadLocal<Map<Object, Logger>> loggersTLS = ThreadLocal.withInitial(() -> new HashMap());
    private static final Logger stringLogger = LoggerFactory.getLogger((String)"stevlog");
    private final String id;
    private final Clock clock;
    private String traceId = null;
    private String parentId = null;
    private List<Object> attributes = null;
    private Level level = Level.INFO;
    private Throwable throwable = null;
    private Instant startTime = null;
    private final EventResourcesImpl resources;

    Slf4jEvent(Clock clock, EventResourcesImpl parentResources) {
        this.id = Slf4jEvent.randomId();
        this.clock = clock;
        this.resources = new EventResourcesImpl(parentResources);
    }

    @Override
    public Event newChildEvent() {
        return new Slf4jEvent(this.clock, this.resources).traceId(this.traceId).parentId(this.id);
    }

    @Override
    public Event traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @Override
    public Event parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @Override
    public Event timed() {
        this.startTime = this.clock.instant();
        return this;
    }

    @Override
    public Event sampled(Object samplingKey, int duration, TimeUnit unit) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Event resources(EventResources other) {
        if (other instanceof EventResourcesImpl) {
            this.resources.copyFrom((EventResourcesImpl)other);
        }
        return this;
    }

    @Override
    public Event resource(String key, Object value) {
        this.resources.resource(key, value);
        return this;
    }

    @Override
    public Event resource(String key, Supplier<String> value) {
        this.resources.resource(key, value);
        return this;
    }

    @Override
    public Event attr(String key, Object value) {
        this.getAttributes().add(key);
        this.getAttributes().add(value);
        return this;
    }

    @Override
    public Event attr(String key, Supplier<String> value) {
        this.attr(key, (Object)value);
        return this;
    }

    @Override
    public Event exception(Throwable t) {
        this.throwable = t;
        return this;
    }

    @Override
    public Event atError() {
        this.level = Level.ERROR;
        return this;
    }

    @Override
    public Event atInfo() {
        this.level = Level.INFO;
        return this;
    }

    @Override
    public Event atWarn() {
        this.level = Level.WARN;
        return this;
    }

    @Override
    public void log(Enum<?> event) {
        Logger logger;
        EventGroup g = event.getClass().getAnnotation(EventGroup.class);
        Map<Object, Logger> loggers = loggersTLS.get();
        if (g != null) {
            String component = g.component();
            MDC.put((String)"component", (String)component);
            logger = loggers.get(event);
            if (logger == null) {
                logger = loggers.compute(event, (k, v) -> LoggerFactory.getLogger((String)("stevlog." + component + "." + event)));
            }
        } else {
            logger = loggers.get(event);
            if (logger == null) {
                logger = loggers.compute(event, (k, v) -> LoggerFactory.getLogger((String)("stevlog." + event)));
            }
        }
        this.logInternal(logger, event.toString());
    }

    @Override
    public void log(String event) {
        this.logInternal(stringLogger, event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logInternal(Logger logger, String event) {
        try {
            MDC.put((String)"id", (String)this.id);
            if (this.traceId != null) {
                MDC.put((String)"traceId", (String)this.traceId);
            }
            if (this.parentId != null) {
                MDC.put((String)"parentId", (String)this.parentId);
            }
            this.resources.forEach(MDC::put);
            if (this.attributes != null) {
                EventResourcesImpl.forEach(this.attributes, MDC::put);
            }
            if (this.startTime != null) {
                MDC.put((String)"startTimestamp", (String)this.startTime.toString());
                MDC.put((String)"durationMs", (String)String.valueOf(Duration.between(this.startTime, this.clock.instant()).toMillis()));
            }
            switch (this.level) {
                case ERROR: {
                    if (this.throwable != null) {
                        logger.error(event, this.throwable);
                        return;
                    } else {
                        logger.error(event);
                        return;
                    }
                }
                case WARN: {
                    if (this.throwable != null) {
                        logger.warn(event, this.throwable);
                        return;
                    } else {
                        logger.warn(event);
                        return;
                    }
                }
                default: {
                    if (this.throwable != null) {
                        logger.info(event, this.throwable);
                        return;
                    } else {
                        logger.info(event);
                    }
                    return;
                }
            }
        }
        finally {
            MDC.clear();
        }
    }

    @Override
    public void stash() {
        throw new UnsupportedOperationException("TODO");
    }

    private List<Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Object>();
        }
        return this.attributes;
    }

    static String randomId() {
        return Long.toString(ThreadLocalRandom.current().nextLong(0x100000000000000L, 0xFFFFFFFFFFFFFFFL), 16);
    }

    static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

