/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.spark.util.kvstore.CustomType1;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.LevelDBSuite;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBIteratorSuite {
    private static final Logger LOG = LoggerFactory.getLogger(DBIteratorSuite.class);
    private static final int MIN_ENTRIES = 42;
    private static final int MAX_ENTRIES = 1024;
    private static final Random RND = new Random();
    private static List<CustomType1> allEntries;
    private static List<CustomType1> clashingEntries;
    private static KVStore db;
    private static final BaseComparator NATURAL_ORDER;
    private static final BaseComparator REF_INDEX_ORDER;
    private static final BaseComparator COPY_INDEX_ORDER;
    private static final BaseComparator NUMERIC_INDEX_ORDER;
    private static final BaseComparator CHILD_INDEX_ORDER;

    protected abstract KVStore createStore() throws Exception;

    @BeforeClass
    public static void setupClass() {
        long seed = RND.nextLong();
        LOG.info("Random seed: {}", (Object)seed);
        RND.setSeed(seed);
    }

    @AfterClass
    public static void cleanupData() throws Exception {
        allEntries = null;
        db = null;
    }

    @Before
    public void setup() throws Exception {
        if (db != null) {
            return;
        }
        db = this.createStore();
        int count = RND.nextInt(1024) + 42;
        allEntries = new ArrayList<CustomType1>(count);
        for (int i = 0; i < count; ++i) {
            CustomType1 t = new CustomType1();
            t.key = "key" + i;
            t.id = "id" + i;
            t.name = "name" + RND.nextInt(1024);
            t.num = i != 0 ? (int)RND.nextLong() : 0;
            t.child = "child" + i % 42;
            allEntries.add(t);
        }
        Collections.shuffle(allEntries, RND);
        for (CustomType1 e : allEntries) {
            db.write((Object)e);
        }
        CustomType1 first = allEntries.get(0);
        clashingEntries = new ArrayList<CustomType1>();
        int clashCount = RND.nextInt(42) + 1;
        for (int i = 0; i < clashCount; ++i) {
            CustomType1 t = new CustomType1();
            t.key = "n-key" + (count + i);
            t.id = first.id;
            t.name = first.name;
            t.num = first.num;
            t.child = first.child;
            allEntries.add(t);
            clashingEntries.add(t);
            db.write((Object)t);
        }
        CustomType1 t = new CustomType1();
        t.key = "extended-key-0";
        t.id = first.id;
        t.name = first.name + "a";
        t.num = first.num;
        t.child = first.child;
        allEntries.add(t);
        db.write((Object)t);
    }

    @Test
    public void naturalIndex() throws Exception {
        this.testIteration(NATURAL_ORDER, this.view(), null, null);
    }

    @Test
    public void refIndex() throws Exception {
        this.testIteration(REF_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("id"), null, null);
    }

    @Test
    public void copyIndex() throws Exception {
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("name"), null, null);
    }

    @Test
    public void numericIndex() throws Exception {
        this.testIteration(NUMERIC_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("int"), null, null);
    }

    @Test
    public void childIndex() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id), null, null);
    }

    @Test
    public void naturalIndexDescending() throws Exception {
        this.testIteration(NATURAL_ORDER, (KVStoreView<CustomType1>)this.view().reverse(), null, null);
    }

    @Test
    public void refIndexDescending() throws Exception {
        this.testIteration(REF_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("id").reverse(), null, null);
    }

    @Test
    public void copyIndexDescending() throws Exception {
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("name").reverse(), null, null);
    }

    @Test
    public void numericIndexDescending() throws Exception {
        this.testIteration(NUMERIC_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("int").reverse(), null, null);
    }

    @Test
    public void childIndexDescending() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id).reverse(), null, null);
    }

    @Test
    public void naturalIndexWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(NATURAL_ORDER, (KVStoreView<CustomType1>)this.view().first((Object)first.key), first, null);
    }

    @Test
    public void refIndexWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(REF_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("id").first((Object)first.id), first, null);
    }

    @Test
    public void copyIndexWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("name").first((Object)first.name), first, null);
    }

    @Test
    public void numericIndexWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(NUMERIC_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("int").first((Object)first.num), first, null);
    }

    @Test
    public void childIndexWithStart() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id).first((Object)any.child), null, null);
    }

    @Test
    public void naturalIndexDescendingWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(NATURAL_ORDER, (KVStoreView<CustomType1>)this.view().reverse().first((Object)first.key), first, null);
    }

    @Test
    public void refIndexDescendingWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(REF_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().reverse().index("id").first((Object)first.id), first, null);
    }

    @Test
    public void copyIndexDescendingWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().reverse().index("name").first((Object)first.name), first, null);
    }

    @Test
    public void numericIndexDescendingWithStart() throws Exception {
        CustomType1 first = this.pickLimit();
        this.testIteration(NUMERIC_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().reverse().index("int").first((Object)first.num), first, null);
    }

    @Test
    public void childIndexDescendingWithStart() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id).first((Object)any.child).reverse(), null, null);
    }

    @Test
    public void naturalIndexWithSkip() throws Exception {
        this.testIteration(NATURAL_ORDER, (KVStoreView<CustomType1>)this.view().skip((long)this.pickCount()), null, null);
    }

    @Test
    public void refIndexWithSkip() throws Exception {
        this.testIteration(REF_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("id").skip((long)this.pickCount()), null, null);
    }

    @Test
    public void copyIndexWithSkip() throws Exception {
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("name").skip((long)this.pickCount()), null, null);
    }

    @Test
    public void childIndexWithSkip() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id).skip((long)this.pickCount()), null, null);
    }

    @Test
    public void naturalIndexWithMax() throws Exception {
        this.testIteration(NATURAL_ORDER, (KVStoreView<CustomType1>)this.view().max((long)this.pickCount()), null, null);
    }

    @Test
    public void copyIndexWithMax() throws Exception {
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("name").max((long)this.pickCount()), null, null);
    }

    @Test
    public void childIndexWithMax() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id).max((long)this.pickCount()), null, null);
    }

    @Test
    public void naturalIndexWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(NATURAL_ORDER, (KVStoreView<CustomType1>)this.view().last((Object)last.key), null, last);
    }

    @Test
    public void refIndexWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(REF_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("id").last((Object)last.id), null, last);
    }

    @Test
    public void copyIndexWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("name").last((Object)last.name), null, last);
    }

    @Test
    public void numericIndexWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(NUMERIC_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("int").last((Object)last.num), null, last);
    }

    @Test
    public void childIndexWithLast() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id).last((Object)any.child), null, null);
    }

    @Test
    public void naturalIndexDescendingWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(NATURAL_ORDER, (KVStoreView<CustomType1>)this.view().reverse().last((Object)last.key), null, last);
    }

    @Test
    public void refIndexDescendingWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(REF_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().reverse().index("id").last((Object)last.id), null, last);
    }

    @Test
    public void copyIndexDescendingWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(COPY_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().reverse().index("name").last((Object)last.name), null, last);
    }

    @Test
    public void numericIndexDescendingWithLast() throws Exception {
        CustomType1 last = this.pickLimit();
        this.testIteration(NUMERIC_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().reverse().index("int").last((Object)last.num), null, last);
    }

    @Test
    public void childIndexDescendingWithLast() throws Exception {
        CustomType1 any = this.pickLimit();
        this.testIteration(CHILD_INDEX_ORDER, (KVStoreView<CustomType1>)this.view().index("child").parent((Object)any.id).last((Object)any.child).reverse(), null, null);
    }

    @Test
    public void testRefWithIntNaturalKey() throws Exception {
        LevelDBSuite.IntKeyType i = new LevelDBSuite.IntKeyType();
        i.key = 1;
        i.id = "1";
        i.values = Arrays.asList("1");
        db.write((Object)i);
        try (KVStoreIterator it = db.view(i.getClass()).closeableIterator();){
            Object read = it.next();
            Assert.assertEquals((Object)i, (Object)read);
        }
    }

    private CustomType1 pickLimit() {
        return clashingEntries.get(RND.nextInt(clashingEntries.size()));
    }

    private int pickCount() {
        int count = RND.nextInt(allEntries.size() / 2);
        return Math.max(count, 1);
    }

    private <T extends Comparable<T>> int compareWithFallback(T v1, T v2, CustomType1 ct1, CustomType1 ct2) {
        int result = v1.compareTo(v2);
        if (result != 0) {
            return result;
        }
        return ct1.key.compareTo(ct2.key);
    }

    private void testIteration(BaseComparator order, KVStoreView<CustomType1> params, CustomType1 first, CustomType1 last) throws Exception {
        BaseComparator expectedOrder;
        List indexOrder = this.sortBy(order.fallback());
        if (!params.ascending) {
            indexOrder = Lists.reverse(indexOrder);
        }
        Iterable expected = indexOrder;
        BaseComparator baseComparator = expectedOrder = params.ascending ? order : order.reverse();
        if (params.parent != null) {
            expected = Iterables.filter((Iterable)expected, v -> params.parent.equals(v.id));
        }
        if (first != null) {
            expected = Iterables.filter((Iterable)expected, v -> expectedOrder.compare(first, v) <= 0);
        }
        if (last != null) {
            expected = Iterables.filter((Iterable)expected, v -> expectedOrder.compare(v, last) <= 0);
        }
        if (params.skip > 0L) {
            expected = Iterables.skip((Iterable)expected, (int)((int)params.skip));
        }
        if (params.max != Long.MAX_VALUE) {
            expected = Iterables.limit((Iterable)expected, (int)((int)params.max));
        }
        List<CustomType1> actual = this.collect(params);
        this.compareLists(expected, actual);
    }

    private void compareLists(Iterable<?> expected, List<?> actual) {
        String message;
        Object[] remaining;
        Iterator<?> expectedIt = expected.iterator();
        Iterator<?> actualIt = actual.iterator();
        int count = 0;
        while (expectedIt.hasNext() && actualIt.hasNext()) {
            ++count;
            Assert.assertEquals(expectedIt.next(), actualIt.next());
        }
        int expectedCount = count;
        int actualCount = count;
        if (expectedIt.hasNext()) {
            remaining = Iterators.toArray(expectedIt, Object.class);
            expectedCount += remaining.length;
            message = "missing";
        } else {
            remaining = Iterators.toArray(actualIt, Object.class);
            actualCount += remaining.length;
            message = "stray";
        }
        Assert.assertEquals((String)String.format("Found %s elements: %s", message, Arrays.asList(remaining)), (long)expectedCount, (long)actualCount);
    }

    private KVStoreView<CustomType1> view() throws Exception {
        return db.view(CustomType1.class);
    }

    private List<CustomType1> collect(KVStoreView<CustomType1> view) throws Exception {
        return Arrays.asList((CustomType1[])Iterables.toArray(view, CustomType1.class));
    }

    private List<CustomType1> sortBy(Comparator<CustomType1> comp) {
        ArrayList<CustomType1> copy = new ArrayList<CustomType1>(allEntries);
        Collections.sort(copy, comp);
        return copy;
    }

    static {
        NATURAL_ORDER = (t1, t2) -> t1.key.compareTo(t2.key);
        REF_INDEX_ORDER = (t1, t2) -> t1.id.compareTo(t2.id);
        COPY_INDEX_ORDER = (t1, t2) -> t1.name.compareTo(t2.name);
        NUMERIC_INDEX_ORDER = (t1, t2) -> Integer.valueOf(t1.num).compareTo(t2.num);
        CHILD_INDEX_ORDER = (t1, t2) -> t1.child.compareTo(t2.child);
    }

    private static interface BaseComparator
    extends Comparator<CustomType1> {
        default public BaseComparator fallback() {
            return (t1, t2) -> {
                int result = this.compare(t1, t2);
                if (result != 0) {
                    return result;
                }
                return t1.key.compareTo(t2.key);
            };
        }

        default public BaseComparator reverse() {
            return (t1, t2) -> -this.compare(t1, t2);
        }
    }
}

