/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.spark.util.kvstore.KVIndex;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.LevelDB;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;

@Ignore
public class LevelDBBenchmark {
    private static final int COUNT = 1024;
    private static final AtomicInteger IDGEN = new AtomicInteger();
    private static final MetricRegistry metrics = new MetricRegistry();
    private static final Timer dbCreation = metrics.timer("dbCreation");
    private static final Timer dbClose = metrics.timer("dbClose");
    private LevelDB db;
    private File dbpath;

    @Before
    public void setup() throws Exception {
        this.dbpath = File.createTempFile("test.", ".ldb");
        this.dbpath.delete();
        try (Timer.Context ctx = dbCreation.time();){
            this.db = new LevelDB(this.dbpath);
        }
    }

    @After
    public void cleanup() throws Exception {
        if (this.db != null) {
            try (Timer.Context ctx = dbClose.time();){
                this.db.close();
            }
        }
        if (this.dbpath != null) {
            FileUtils.deleteQuietly((File)this.dbpath);
        }
    }

    @AfterClass
    public static void report() {
        if (metrics.getTimers().isEmpty()) {
            return;
        }
        int headingPrefix = 0;
        for (Map.Entry e : metrics.getTimers().entrySet()) {
            headingPrefix = Math.max(((String)e.getKey()).length(), headingPrefix);
        }
        headingPrefix += 4;
        StringBuilder heading = new StringBuilder();
        for (int i = 0; i < headingPrefix; ++i) {
            heading.append(" ");
        }
        heading.append("\tcount");
        heading.append("\tmean");
        heading.append("\tmin");
        heading.append("\tmax");
        heading.append("\t95th");
        System.out.println(heading);
        for (Map.Entry e : metrics.getTimers().entrySet()) {
            StringBuilder row = new StringBuilder();
            row.append((String)e.getKey());
            for (int i = 0; i < headingPrefix - ((String)e.getKey()).length(); ++i) {
                row.append(" ");
            }
            Snapshot s = ((Timer)e.getValue()).getSnapshot();
            row.append("\t").append(((Timer)e.getValue()).getCount());
            row.append("\t").append(LevelDBBenchmark.toMs(s.getMean()));
            row.append("\t").append(LevelDBBenchmark.toMs(s.getMin()));
            row.append("\t").append(LevelDBBenchmark.toMs(s.getMax()));
            row.append("\t").append(LevelDBBenchmark.toMs(s.get95thPercentile()));
            System.out.println(row);
        }
        Slf4jReporter.forRegistry((MetricRegistry)metrics).outputTo(LoggerFactory.getLogger(LevelDBBenchmark.class)).build().report();
    }

    private static String toMs(double nanos) {
        return String.format("%.3f", nanos / 1000.0 / 1000.0);
    }

    @Test
    public void sequentialWritesNoIndex() throws Exception {
        List<SimpleType> entries = this.createSimpleType();
        this.writeAll(entries, "sequentialWritesNoIndex");
        this.writeAll(entries, "sequentialUpdatesNoIndex");
        this.deleteNoIndex(entries, "sequentialDeleteNoIndex");
    }

    @Test
    public void randomWritesNoIndex() throws Exception {
        List<SimpleType> entries = this.createSimpleType();
        Collections.shuffle(entries);
        this.writeAll(entries, "randomWritesNoIndex");
        Collections.shuffle(entries);
        this.writeAll(entries, "randomUpdatesNoIndex");
        Collections.shuffle(entries);
        this.deleteNoIndex(entries, "randomDeletesNoIndex");
    }

    @Test
    public void sequentialWritesIndexedType() throws Exception {
        List<IndexedType> entries = this.createIndexedType();
        this.writeAll(entries, "sequentialWritesIndexed");
        this.writeAll(entries, "sequentialUpdatesIndexed");
        this.deleteIndexed(entries, "sequentialDeleteIndexed");
    }

    @Test
    public void randomWritesIndexedTypeAndIteration() throws Exception {
        List<IndexedType> entries = this.createIndexedType();
        Collections.shuffle(entries);
        this.writeAll(entries, "randomWritesIndexed");
        Collections.shuffle(entries);
        this.writeAll(entries, "randomUpdatesIndexed");
        KVStoreView view = this.db.view(IndexedType.class);
        this.iterate(view, "naturalIndex");
        this.iterate(view.reverse(), "naturalIndexDescending");
        this.iterate(view.index("name"), "refIndex");
        this.iterate(view.index("name").reverse(), "refIndexDescending");
        Collections.shuffle(entries);
        this.deleteIndexed(entries, "randomDeleteIndexed");
    }

    private void iterate(KVStoreView<?> view, String name) throws Exception {
        Timer create = metrics.timer(name + "CreateIterator");
        Timer iter = metrics.timer(name + "Iteration");
        KVStoreIterator it = null;
        for (int i = 0; i < 1024; ++i) {
            if (it != null) {
                it.close();
            }
            try (Timer.Context ctx = create.time();){
                it = view.closeableIterator();
                continue;
            }
        }
        while (it.hasNext()) {
            Timer.Context ctx = iter.time();
            try {
                it.next();
            }
            finally {
                if (ctx == null) continue;
                ctx.close();
            }
        }
    }

    private void writeAll(List<?> entries, String timerName) throws Exception {
        Timer timer = this.newTimer(timerName);
        for (Object o : entries) {
            Timer.Context ctx = timer.time();
            try {
                this.db.write(o);
            }
            finally {
                if (ctx == null) continue;
                ctx.close();
            }
        }
    }

    private void deleteNoIndex(List<SimpleType> entries, String timerName) throws Exception {
        Timer delete = this.newTimer(timerName);
        for (SimpleType i : entries) {
            Timer.Context ctx = delete.time();
            try {
                this.db.delete(i.getClass(), (Object)i.key);
            }
            finally {
                if (ctx == null) continue;
                ctx.close();
            }
        }
    }

    private void deleteIndexed(List<IndexedType> entries, String timerName) throws Exception {
        Timer delete = this.newTimer(timerName);
        for (IndexedType i : entries) {
            Timer.Context ctx = delete.time();
            try {
                this.db.delete(i.getClass(), (Object)i.key);
            }
            finally {
                if (ctx == null) continue;
                ctx.close();
            }
        }
    }

    private List<SimpleType> createSimpleType() {
        ArrayList<SimpleType> entries = new ArrayList<SimpleType>();
        for (int i = 0; i < 1024; ++i) {
            SimpleType t = new SimpleType();
            t.key = IDGEN.getAndIncrement();
            t.name = "name" + t.key % 1024;
            entries.add(t);
        }
        return entries;
    }

    private List<IndexedType> createIndexedType() {
        ArrayList<IndexedType> entries = new ArrayList<IndexedType>();
        for (int i = 0; i < 1024; ++i) {
            IndexedType t = new IndexedType();
            t.key = IDGEN.getAndIncrement();
            t.name = "name" + t.key % 1024;
            entries.add(t);
        }
        return entries;
    }

    private Timer newTimer(String name) {
        Assert.assertNull((String)("Timer already exists: " + name), metrics.getTimers().get(name));
        return metrics.timer(name);
    }

    public static class IndexedType {
        @KVIndex
        public int key;
        @KVIndex(value="name")
        public String name;
    }

    public static class SimpleType {
        @KVIndex
        public int key;
        public String name;
    }
}

