/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.nio.charset.StandardCharsets;
import org.apache.spark.util.kvstore.CustomType1;
import org.apache.spark.util.kvstore.KVIndex;
import org.apache.spark.util.kvstore.KVTypeInfo;
import org.apache.spark.util.kvstore.LevelDBTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class LevelDBTypeInfoSuite {
    @Test
    public void testIndexAnnotation() throws Exception {
        KVTypeInfo ti = new KVTypeInfo(CustomType1.class);
        Assert.assertEquals((long)5L, (long)ti.indices().count());
        CustomType1 t1 = new CustomType1();
        t1.key = "key";
        t1.id = "id";
        t1.name = "name";
        t1.num = 42;
        t1.child = "child";
        Assert.assertEquals((Object)t1.key, (Object)ti.getIndexValue("__main__", (Object)t1));
        Assert.assertEquals((Object)t1.id, (Object)ti.getIndexValue("id", (Object)t1));
        Assert.assertEquals((Object)t1.name, (Object)ti.getIndexValue("name", (Object)t1));
        Assert.assertEquals((Object)t1.num, (Object)ti.getIndexValue("int", (Object)t1));
        Assert.assertEquals((Object)t1.child, (Object)ti.getIndexValue("child", (Object)t1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNaturalIndex() throws Exception {
        this.newTypeInfo(NoNaturalIndex.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNaturalIndex2() throws Exception {
        this.newTypeInfo(NoNaturalIndex2.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateIndex() throws Exception {
        this.newTypeInfo(DuplicateIndex.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyIndexName() throws Exception {
        this.newTypeInfo(EmptyIndexName.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalIndexName() throws Exception {
        this.newTypeInfo(IllegalIndexName.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalIndexMethod() throws Exception {
        this.newTypeInfo(IllegalIndexMethod.class);
    }

    @Test
    public void testKeyClashes() throws Exception {
        LevelDBTypeInfo ti = this.newTypeInfo(CustomType1.class);
        CustomType1 t1 = new CustomType1();
        t1.key = "key1";
        t1.name = "a";
        CustomType1 t2 = new CustomType1();
        t2.key = "key2";
        t2.name = "aa";
        CustomType1 t3 = new CustomType1();
        t3.key = "key3";
        t3.name = "aaa";
        this.assertBefore(ti.index("name").entityKey(null, (Object)t1), ti.index("name").entityKey(null, (Object)t2));
        this.assertBefore(ti.index("name").entityKey(null, (Object)t1), ti.index("name").entityKey(null, (Object)t3));
        this.assertBefore(ti.index("name").entityKey(null, (Object)t2), ti.index("name").entityKey(null, (Object)t3));
    }

    @Test
    public void testNumEncoding() throws Exception {
        LevelDBTypeInfo.Index idx = (LevelDBTypeInfo.Index)this.newTypeInfo(CustomType1.class).indices().iterator().next();
        Assert.assertEquals((Object)"+=00000001", (Object)new String(idx.toKey((Object)1), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"+=00000010", (Object)new String(idx.toKey((Object)16), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"+=7fffffff", (Object)new String(idx.toKey((Object)Integer.MAX_VALUE), StandardCharsets.UTF_8));
        this.assertBefore(idx.toKey((Object)1), idx.toKey((Object)2));
        this.assertBefore(idx.toKey((Object)-1), idx.toKey((Object)2));
        this.assertBefore(idx.toKey((Object)-11), idx.toKey((Object)2));
        this.assertBefore(idx.toKey((Object)-11), idx.toKey((Object)-1));
        this.assertBefore(idx.toKey((Object)1), idx.toKey((Object)11));
        this.assertBefore(idx.toKey((Object)Integer.MIN_VALUE), idx.toKey((Object)Integer.MAX_VALUE));
        this.assertBefore(idx.toKey((Object)1L), idx.toKey((Object)2L));
        this.assertBefore(idx.toKey((Object)-1L), idx.toKey((Object)2L));
        this.assertBefore(idx.toKey((Object)Long.MIN_VALUE), idx.toKey((Object)Long.MAX_VALUE));
        this.assertBefore(idx.toKey((Object)1), idx.toKey((Object)2));
        this.assertBefore(idx.toKey((Object)-1), idx.toKey((Object)2));
        this.assertBefore(idx.toKey((Object)Short.MIN_VALUE), idx.toKey((Object)Short.MAX_VALUE));
        this.assertBefore(idx.toKey((Object)1), idx.toKey((Object)2));
        this.assertBefore(idx.toKey((Object)-1), idx.toKey((Object)2));
        this.assertBefore(idx.toKey((Object)-128), idx.toKey((Object)127));
        byte prefix = 43;
        this.assertSame(new byte[]{prefix, LevelDBTypeInfo.FALSE}, idx.toKey((Object)false));
        this.assertSame(new byte[]{prefix, LevelDBTypeInfo.TRUE}, idx.toKey((Object)true));
    }

    @Test
    public void testArrayIndices() throws Exception {
        LevelDBTypeInfo.Index idx = (LevelDBTypeInfo.Index)this.newTypeInfo(CustomType1.class).indices().iterator().next();
        this.assertBefore(idx.toKey((Object)new String[]{"str1"}), idx.toKey((Object)new String[]{"str2"}));
        this.assertBefore(idx.toKey((Object)new String[]{"str1", "str2"}), idx.toKey((Object)new String[]{"str1", "str3"}));
        this.assertBefore(idx.toKey((Object)new int[]{1}), idx.toKey((Object)new int[]{2}));
        this.assertBefore(idx.toKey((Object)new int[]{1, 2}), idx.toKey((Object)new int[]{1, 3}));
    }

    private LevelDBTypeInfo newTypeInfo(Class<?> type) throws Exception {
        return new LevelDBTypeInfo(null, type, type.getName().getBytes(StandardCharsets.UTF_8));
    }

    private void assertBefore(byte[] key1, byte[] key2) {
        this.assertBefore(new String(key1, StandardCharsets.UTF_8), new String(key2, StandardCharsets.UTF_8));
    }

    private void assertBefore(String str1, String str2) {
        Assert.assertTrue((String)String.format("%s < %s failed", str1, str2), (str1.compareTo(str2) < 0 ? 1 : 0) != 0);
    }

    private void assertSame(byte[] key1, byte[] key2) {
        Assert.assertEquals((Object)new String(key1, StandardCharsets.UTF_8), (Object)new String(key2, StandardCharsets.UTF_8));
    }

    public static class IllegalIndexMethod {
        @KVIndex(value="id")
        public String id(boolean illegalParam) {
            return null;
        }
    }

    public static class IllegalIndexName {
        @KVIndex(value="__invalid")
        public String id;
    }

    public static class EmptyIndexName {
        @KVIndex(value="")
        public String id;
    }

    public static class DuplicateIndex {
        @KVIndex
        public String key;
        @KVIndex(value="id")
        public String id;
        @KVIndex(value="id")
        public String id2;
    }

    public static class NoNaturalIndex2 {
        @KVIndex(value="id")
        public String id;
    }

    public static class NoNaturalIndex {
        public String id;
    }
}

