/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.launcher.CommandArgsSanitizer;
import org.junit.Assert;
import org.junit.Test;

public class CommandArgsSanitizerSuite {
    @Test
    public void testSanitizeCommand() {
        final List<String> sanitizableArgs = Arrays.asList("hive.server2.keystore.password=1234567890", "spark.cassandra.auth.password=1234567890", "spark.cassandra.connection.ssl.keyStore.password=1234567890", "spark.cassandra.connection.ssl.trustStore.password=1234567890");
        final List<String> sanitizedArgs = Arrays.asList("hive.server2.keystore.password=*****", "spark.cassandra.auth.password=*****", "spark.cassandra.connection.ssl.keyStore.password=*****", "spark.cassandra.connection.ssl.trustStore.password=*****");
        final List<String> nonSanitizableArgs = Arrays.asList("some.unknown.argument.password=xyz", "some.password.argument=xyz");
        ArrayList<String> argsToSanitize = new ArrayList<String>(){
            {
                this.addAll(sanitizableArgs);
                this.addAll(nonSanitizableArgs);
            }
        };
        ArrayList<String> expectedSanitizedArgs = new ArrayList<String>(){
            {
                this.addAll(sanitizedArgs);
                this.addAll(nonSanitizableArgs);
            }
        };
        List args = CommandArgsSanitizer.sanitizeCommand((List)argsToSanitize);
        Assert.assertArrayEquals((Object[])expectedSanitizedArgs.toArray(), (Object[])args.toArray());
    }
}

