/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandArgsSanitizer;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkClassCommandBuilder;
import org.apache.spark.launcher.SparkSubmitCommandBuilder;
import org.apache.spark.launcher.SparkSubmitOptionParser;

class Main {
    Main() {
    }

    public static void main(String[] argsArray) throws Exception {
        List<String> cmd;
        AbstractCommandBuilder builder;
        CommandBuilderUtils.checkArgument(argsArray.length > 0, "Not enough arguments: missing class name.", new Object[0]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArray));
        String className = (String)args.remove(0);
        boolean printLaunchCommand = !CommandBuilderUtils.isEmpty(System.getenv("SPARK_PRINT_LAUNCH_COMMAND"));
        HashMap<String, String> env = new HashMap<String, String>();
        if (className.equals("org.apache.spark.deploy.SparkSubmit")) {
            try {
                builder = new SparkSubmitCommandBuilder(args);
                cmd = Main.buildCommand(builder, env, printLaunchCommand);
            }
            catch (IllegalArgumentException e) {
                printLaunchCommand = false;
                System.err.println("Error: " + e.getMessage());
                System.err.println();
                MainClassOptionParser parser = new MainClassOptionParser();
                try {
                    parser.parse(args);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList<String> help = new ArrayList<String>();
                if (parser.className != null) {
                    Objects.requireNonNull(parser);
                    help.add("--class");
                    help.add(parser.className);
                }
                Objects.requireNonNull(parser);
                help.add("--usage-error");
                SparkSubmitCommandBuilder builder2 = new SparkSubmitCommandBuilder(help);
                cmd = Main.buildCommand(builder2, env, printLaunchCommand);
            }
        } else {
            builder = new SparkClassCommandBuilder(className, args);
            cmd = Main.buildCommand(builder, env, printLaunchCommand);
        }
        if (CommandBuilderUtils.isWindows()) {
            System.out.println(Main.prepareWindowsCommand(cmd, env));
        } else {
            List<String> bashCmd = Main.prepareBashCommand(cmd, env);
            for (String c : bashCmd) {
                System.out.print(c);
                System.out.print('\u0000');
            }
        }
    }

    private static List<String> buildCommand(AbstractCommandBuilder builder, Map<String, String> env, boolean printLaunchCommand) throws IOException, IllegalArgumentException {
        List<String> cmd = builder.buildCommand(env);
        if (printLaunchCommand) {
            System.err.println("Spark Command: " + CommandBuilderUtils.join(" ", CommandArgsSanitizer.sanitizeCommand(cmd)));
            System.err.println("========================================");
        }
        return cmd;
    }

    private static String prepareWindowsCommand(List<String> cmd, Map<String, String> childEnv) {
        StringBuilder cmdline = new StringBuilder();
        for (Map.Entry<String, String> e : childEnv.entrySet()) {
            cmdline.append(String.format("set %s=%s", e.getKey(), e.getValue()));
            cmdline.append(" && ");
        }
        for (String arg : cmd) {
            cmdline.append(CommandBuilderUtils.quoteForBatchScript(arg));
            cmdline.append(" ");
        }
        return cmdline.toString();
    }

    private static List<String> prepareBashCommand(List<String> cmd, Map<String, String> childEnv) {
        if (childEnv.isEmpty()) {
            return cmd;
        }
        ArrayList<String> newCmd = new ArrayList<String>();
        newCmd.add("env");
        for (Map.Entry<String, String> e : childEnv.entrySet()) {
            newCmd.add(String.format("%s=%s", e.getKey(), e.getValue()));
        }
        newCmd.addAll(cmd);
        return newCmd;
    }

    private static class MainClassOptionParser
    extends SparkSubmitOptionParser {
        String className;

        private MainClassOptionParser() {
        }

        @Override
        protected boolean handle(String opt, String value) {
            if ("--class".equals(opt)) {
                this.className = value;
            }
            return false;
        }

        @Override
        protected boolean handleUnknown(String opt) {
            return false;
        }

        @Override
        protected void handleExtraArgs(List<String> extra) {
        }
    }
}

