/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.spark.network.crypto.AuthEngine;
import org.apache.spark.network.crypto.ClientChallenge;
import org.apache.spark.network.crypto.ServerResponse;
import org.apache.spark.network.crypto.TransportCipher;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AuthEngineSuite {
    private static TransportConf conf;

    @BeforeClass
    public static void setUp() {
        conf = new TransportConf("rpc", (ConfigProvider)MapConfigProvider.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthEngine() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "secret", conf);
        try {
            ClientChallenge clientChallenge = client.challenge();
            ServerResponse serverResponse = server.respond(clientChallenge);
            client.validate(serverResponse);
            TransportCipher serverCipher = server.sessionCipher();
            TransportCipher clientCipher = client.sessionCipher();
            Assert.assertTrue((boolean)Arrays.equals(serverCipher.getInputIv(), clientCipher.getOutputIv()));
            Assert.assertTrue((boolean)Arrays.equals(serverCipher.getOutputIv(), clientCipher.getInputIv()));
            Assert.assertEquals((Object)serverCipher.getKey(), (Object)clientCipher.getKey());
        }
        finally {
            client.close();
            server.close();
        }
    }

    @Test
    public void testMismatchedSecret() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "different_secret", conf);
        ClientChallenge clientChallenge = client.challenge();
        try {
            server.respond(clientChallenge);
            Assert.fail((String)"Should have failed to validate response.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongAppId() throws Exception {
        AuthEngine engine = new AuthEngine("appId", "secret", conf);
        ClientChallenge challenge = engine.challenge();
        byte[] badChallenge = engine.challenge(new byte[]{0}, challenge.nonce, engine.rawResponse(engine.challenge));
        engine.respond(new ClientChallenge(challenge.appId, challenge.kdf, challenge.iterations, challenge.cipher, challenge.keyLength, challenge.nonce, badChallenge));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongNonce() throws Exception {
        AuthEngine engine = new AuthEngine("appId", "secret", conf);
        ClientChallenge challenge = engine.challenge();
        byte[] badChallenge = engine.challenge(challenge.appId.getBytes(StandardCharsets.UTF_8), new byte[]{0}, engine.rawResponse(engine.challenge));
        engine.respond(new ClientChallenge(challenge.appId, challenge.kdf, challenge.iterations, challenge.cipher, challenge.keyLength, challenge.nonce, badChallenge));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadChallenge() throws Exception {
        AuthEngine engine = new AuthEngine("appId", "secret", conf);
        ClientChallenge challenge = engine.challenge();
        byte[] badChallenge = new byte[challenge.challenge.length];
        engine.respond(new ClientChallenge(challenge.appId, challenge.kdf, challenge.iterations, challenge.cipher, challenge.keyLength, challenge.nonce, badChallenge));
    }
}

