/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.repl.Main$;
import org.apache.spark.repl.ReplSuite$;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.settings.MutableSettings;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.ILoop;
import scala.tools.nsc.interpreter.ILoop$;
import scala.tools.nsc.interpreter.InteractiveReader;
import scala.tools.nsc.interpreter.SimpleReader$;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u0017\tI!+\u001a9m'VLG/\u001a\u0006\u0003\u0007\u0011\tAA]3qY*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u000f\u001b\u0005!\u0011BA\b\u0005\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003)\u0001i\u0011A\u0001\u0005\u0006-\u0001!\taF\u0001\u000feVt\u0017J\u001c;feB\u0014X\r^3s)\rA\"\u0005\n\t\u00033}q!AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0011\"\u0005\u0019\u0019FO]5oO*\u0011ad\u0007\u0005\u0006GU\u0001\r\u0001G\u0001\u0007[\u0006\u001cH/\u001a:\t\u000b\u0015*\u0002\u0019\u0001\r\u0002\u000b%t\u0007/\u001e;\t\u000b\u001d\u0002A\u0011\u0001\u0015\u00023I,h.\u00138uKJ\u0004(/\u001a;fe&s\u0007+Y:uK6{G-\u001a\u000b\u00041%R\u0003\"B\u0012'\u0001\u0004A\u0002\"B\u0013'\u0001\u0004A\u0002\"\u0002\u0017\u0001\t\u0003i\u0013AD1tg\u0016\u0014HoQ8oi\u0006Lgn\u001d\u000b\u0004]E\u001a\u0004C\u0001\u000e0\u0013\t\u00014D\u0001\u0003V]&$\b\"\u0002\u001a,\u0001\u0004A\u0012aB7fgN\fw-\u001a\u0005\u0006i-\u0002\r\u0001G\u0001\u0007_V$\b/\u001e;\t\u000bY\u0002A\u0011A\u001c\u0002)\u0005\u001c8/\u001a:u\t>,7OT8u\u0007>tG/Y5o)\rq\u0003(\u000f\u0005\u0006eU\u0002\r\u0001\u0007\u0005\u0006iU\u0002\r\u0001\u0007")
public class ReplSuite
extends SparkFunSuite {
    public String runInterpreter(String master, String input) {
        String CONF_EXECUTOR_CLASSPATH = "spark.executor.extraClassPath";
        BufferedReader in = new BufferedReader(new StringReader(new StringBuilder().append((Object)input).append((Object)"\n").toString()));
        StringWriter out = new StringWriter();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ObjectRef paths = ObjectRef.create((Object)new ArrayBuffer());
        if (cl instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)cl;
            Predef$.MODULE$.refArrayOps((Object[])urlLoader.getURLs()).foreach((Function1)new Serializable(this, paths){
                public static final long serialVersionUID = 0L;
                private final ObjectRef paths$1;

                public final Object apply(URL url) {
                    String string = url.getProtocol();
                    String string2 = "file";
                    return !(string != null ? !string.equals(string2) : string2 != null) ? ((ArrayBuffer)this.paths$1.elem).$plus$eq((Object)url.getFile()) : BoxedUnit.UNIT;
                }
                {
                    this.paths$1 = paths$1;
                }
            });
        }
        String classpath = ((TraversableOnce)((ArrayBuffer)paths.elem).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return new File(x$1).getAbsolutePath();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(File.pathSeparator);
        String oldExecutorClasspath = System.getProperty(CONF_EXECUTOR_CLASSPATH);
        System.setProperty(CONF_EXECUTOR_CLASSPATH, classpath);
        Main$.MODULE$.sparkContext_$eq(null);
        Main$.MODULE$.sparkSession_$eq(null);
        Main$.MODULE$.conf().set("spark.master", master);
        Main$.MODULE$.doMain((String[])((Object[])new String[]{"-classpath", classpath}), new SparkILoop(in, new PrintWriter(out)));
        String string = oldExecutorClasspath == null ? System.clearProperty(CONF_EXECUTOR_CLASSPATH) : System.setProperty(CONF_EXECUTOR_CLASSPATH, oldExecutorClasspath);
        return out.toString();
    }

    public String runInterpreterInPasteMode(String master, String input) {
        return this.runInterpreter(master, new StringBuilder().append((Object)":paste\n").append((Object)input).append((Object)BoxesRunTime.boxToCharacter((char)((char)4))).toString());
    }

    public void assertContains(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Interpreter output did not contain '").append((Object)message).append((Object)"':\n").append((Object)output).toString(), Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    public void assertDoesNotContain(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"Interpreter output contained '").append((Object)message).append((Object)"':\n").append((Object)output).toString(), Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    public ReplSuite() {
        this.test("propagation of local properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            public final String apply() {
                StringWriter out = new StringWriter();
                public class Org_apache_spark_repl_ReplSuite$$anonfun$9$ILoop$1
                extends SparkILoop {
                    public final /* synthetic */ $anonfun$9 $outer;

                    public /* synthetic */ $anonfun$9 org$apache$spark$repl$ReplSuite$$anonfun$ILoop$$$outer() {
                        return this.$outer;
                    }

                    public Org_apache_spark_repl_ReplSuite$$anonfun$9$ILoop$1($anonfun$9 $outer, PrintWriter out) {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super((Option)None$.MODULE$, out);
                        this.settings_$eq(new Settings());
                        ((MutableSettings.SettingValue)this.settings().usejavacp()).value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        Main$.MODULE$.interp_$eq((SparkILoop)this);
                        this.in_$eq((InteractiveReader)SimpleReader$.MODULE$.apply(SimpleReader$.MODULE$.apply$default$1(), SimpleReader$.MODULE$.apply$default$2(), SimpleReader$.MODULE$.apply$default$3()));
                    }
                }
                Main$.MODULE$.interp_$eq((SparkILoop)new Org_apache_spark_repl_ReplSuite$$anonfun$9$ILoop$1(this, new PrintWriter(out)));
                Main$.MODULE$.sparkContext_$eq(new SparkContext("local", "repl-test"));
                Main$.MODULE$.interp().createInterpreter();
                Main$.MODULE$.sparkContext().setLocalProperty("someKey", "someValue");
                ILoop$.MODULE$.loopToInterpreter((ILoop)Main$.MODULE$.interp()).interpret("org.apache.spark.repl.Main.sparkContext.getLocalProperty(\"someKey\")");
                String $org_scalatest_assert_macro_left = out.toString();
                String $org_scalatest_assert_macro_right = "someValue";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
                Main$.MODULE$.sparkContext().stop();
                return System.clearProperty("spark.driver.port");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("SPARK-15236: use Hive catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                BoxedUnit boxedUnit;
                Level logLevel;
                Logger rootLogger;
                block3: {
                    rootLogger = LogManager.getRootLogger();
                    logLevel = rootLogger.getLevel();
                    rootLogger.setLevel(Level.INFO);
                    try {
                        Main$.MODULE$.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive");
                        String output = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n      |spark.sql(\"drop table if exists t_15236\")\n    ")).stripMargin());
                        this.$outer.assertDoesNotContain("error:", output);
                        this.$outer.assertDoesNotContain("Exception", output);
                        if (SparkSession$.MODULE$.hiveClassesArePresent()) {
                            this.$outer.assertContains("HiveMetaStore", output);
                            boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        this.$outer.assertDoesNotContain("HiveMetaStore", output);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        void var2_2;
                        void var1_1;
                        var1_1.setLevel((Level)var2_2);
                        throw throwable;
                    }
                }
                rootLogger.setLevel(logLevel);
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("SPARK-15236: use in-memory catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                BoxedUnit boxedUnit;
                Logger rootLogger = LogManager.getRootLogger();
                Level logLevel = rootLogger.getLevel();
                rootLogger.setLevel(Level.INFO);
                try {
                    Main$.MODULE$.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "in-memory");
                    String output = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n          |spark.sql(\"drop table if exists t_16236\")\n        ")).stripMargin());
                    this.$outer.assertDoesNotContain("error:", output);
                    this.$outer.assertDoesNotContain("Exception", output);
                    this.$outer.assertDoesNotContain("HiveMetaStore", output);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    void var2_2;
                    void var1_1;
                    var1_1.setLevel((Level)var2_2);
                    throw throwable;
                }
                rootLogger.setLevel(logLevel);
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("broadcast vars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |var array = new Array[Int](5)\n        |val broadcastArray = sc.broadcast(array)\n        |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        |array(0) = 5\n        |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
                this.$outer.assertContains("res0: Array[Int] = Array(0, 0, 0, 0, 0)", output);
                this.$outer.assertContains("res2: Array[Int] = Array(5, 0, 0, 0, 0)", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        if (System.getenv("MESOS_NATIVE_JAVA_LIBRARY") != null) {
            this.test("running on Mesos", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplSuite $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    String output = this.$outer.runInterpreter("localquiet", new StringOps(Predef$.MODULE$.augmentString("\n          |var v = 7\n          |def getV() = v\n          |sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n          |v = 10\n          |sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n          |var array = new Array[Int](5)\n          |val broadcastArray = sc.broadcast(array)\n          |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n          |array(0) = 5\n          |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        ")).stripMargin());
                    this.$outer.assertDoesNotContain("error:", output);
                    this.$outer.assertDoesNotContain("Exception", output);
                    this.$outer.assertContains("res0: Int = 70", output);
                    this.$outer.assertContains("res1: Int = 100", output);
                    this.$outer.assertContains("res2: Array[Int] = Array(0, 0, 0, 0, 0)", output);
                    this.$outer.assertContains("res4: Array[Int] = Array(0, 0, 0, 0, 0)", output);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        }
        this.test("line wrapper only initialized once when used as encoder outer scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |val fileName = \"repl-test-\" + System.currentTimeMillis\n        |val tmpDir = System.getProperty(\"java.io.tmpdir\")\n        |val file = new java.io.File(tmpDir, fileName)\n        |def createFile(): Unit = file.createNewFile()\n        |\n        |createFile();case class TestCaseClass(value: Int)\n        |sc.parallelize(1 to 10).map(x => TestCaseClass(x)).collect()\n        |\n        |file.delete()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
        this.test("define case class and create Dataset together with paste mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreterInPasteMode("local-cluster[1,1,1024]", new StringOps(Predef$.MODULE$.augmentString("\n        |import spark.implicits._\n        |case class TestClass(value: Int)\n        |Seq(TestClass(1)).toDS()\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error:", output);
                this.$outer.assertDoesNotContain("Exception", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test(":replay should work correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n     |sc\n     |:replay\n     ")).stripMargin());
                this.$outer.assertDoesNotContain("error: not found: value sc", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("spark-shell should find imported types in class constructors and extends clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.Partition\n        |class P(p: Partition)\n        |class P(val index: Int) extends Partition\n      ")).stripMargin());
                this.$outer.assertDoesNotContain("error: not found: type Partition", output);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        this.test("spark-shell should shadow val/def definitions correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String output1 = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |def myMethod() = \"first definition\"\n        |val tmp = myMethod(); val out = tmp\n        |def myMethod() = \"second definition\"\n        |val tmp = myMethod(); val out = s\"$tmp aabbcc\"\n      ")).stripMargin());
                this.$outer.assertContains("second definition aabbcc", output1);
                String output2 = this.$outer.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |val a = 1\n        |val b = a; val c = b;\n        |val a = 2\n        |val b = a; val c = b;\n        |s\"!!$b!!\"\n      ")).stripMargin());
                this.$outer.assertContains("!!2!!", output2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
    }
}

