/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.BloomFilterSuite$;
import org.apache.spark.util.sketch.IncompatibleMergeException;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001b\t\u0001\"\t\\8p[\u001aKG\u000e^3s'VLG/\u001a\u0006\u0003\u0007\u0011\taa]6fi\u000eD'BA\u0003\u0007\u0003\u0011)H/\u001b7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\u0011\u0011CC\u0001\ng\u000e\fG.\u0019;fgRL!a\u0005\t\u0003\u0011\u0019+hnU;ji\u0016DQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00077\u00059Q\tU*J\u0019>sU#\u0001\u000f\u0010\u0003u\u0001\u0003b\u0010C{C sKc\u001f\u0005\u0007?\u0001\u0001\u000bQ\u0002\u000f\u0002\u0011\u0015\u00036+\u0013'P\u001d\u0002BQ!\t\u0001\u0005\n\t\n!b\u00195fG.\u001cVM\u001d#f)\t\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0003V]&$\b\"\u0002\u0016!\u0001\u0004Y\u0013A\u00024jYR,'\u000f\u0005\u0002\u0019Y%\u0011QF\u0001\u0002\f\u00052|w.\u001c$jYR,'\u000fC\u00030\u0001\u0011\u0005\u0001'\u0001\u0007uKN$\u0018iY2ve\u0006\u001c\u00170\u0006\u00022}Q\u0019!'\u0015.\u0015\u0005M:ECA\u00125\u0011\u001d)d&!AA\u0004Y\n!\"\u001a<jI\u0016t7-\u001a\u00132!\r9$\bP\u0007\u0002q)\u0011\u0011(J\u0001\be\u00164G.Z2u\u0013\tY\u0004H\u0001\u0005DY\u0006\u001c8\u000fV1h!\tid\b\u0004\u0001\u0005\u000b}r#\u0019\u0001!\u0003\u0003Q\u000b\"!\u0011#\u0011\u0005\u0011\u0012\u0015BA\"&\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001J#\n\u0005\u0019+#aA!os\")\u0001J\fa\u0001\u0013\u00069\u0011\u000e^3n\u000f\u0016t\u0007\u0003\u0002\u0013K\u0019rJ!aS\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA'P\u001b\u0005q%BA\u0003&\u0013\t\u0001fJ\u0001\u0004SC:$w.\u001c\u0005\u0006%:\u0002\raU\u0001\tif\u0004XMT1nKB\u0011Ak\u0016\b\u0003IUK!AV\u0013\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-\u0016BQa\u0017\u0018A\u0002q\u000b\u0001B\\;n\u0013R,Wn\u001d\t\u0003IuK!AX\u0013\u0003\u0007%sG\u000fC\u0003a\u0001\u0011\u0005\u0011-\u0001\tuKN$X*\u001a:hK&s\u0007\u000b\\1dKV\u0011!-\u001b\u000b\u0004G2lGC\u00013k)\t\u0019S\rC\u0004g?\u0006\u0005\t9A4\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u00028u!\u0004\"!P5\u0005\u000b}z&\u0019\u0001!\t\u000b!{\u0006\u0019A6\u0011\t\u0011RE\n\u001b\u0005\u0006%~\u0003\ra\u0015\u0005\u00067~\u0003\r\u0001\u0018\u0005\u0006_\u0002!\t\u0001]\u0001\ri\u0016\u001cH/\u0013;f[RK\b/Z\u000b\u0003cb$2A]>})\t\u0019\u0018\u0010\u0006\u0002$i\"9QO\\A\u0001\u0002\b1\u0018AC3wS\u0012,gnY3%gA\u0019qGO<\u0011\u0005uBH!B o\u0005\u0004\u0001\u0005\"\u0002%o\u0001\u0004Q\b\u0003\u0002\u0013K\u0019^DQA\u00158A\u0002MCQa\u00178A\u0002q\u0003")
public class BloomFilterSuite
extends FunSuite {
    private final double EPSILON;

    private final double EPSILON() {
        return 0.01;
    }

    public void org$apache$spark$util$sketch$BloomFilterSuite$$checkSerDe(BloomFilter filter) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        filter.writeTo((OutputStream)out);
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BloomFilter deserialized = BloomFilter.readFrom((InputStream)in);
        in.close();
        BloomFilter $org_scalatest_assert_macro_left = filter;
        BloomFilter $org_scalatest_assert_macro_right = deserialized;
        BloomFilter bloomFilter = $org_scalatest_assert_macro_left;
        BloomFilter bloomFilter2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bloomFilter != null ? !bloomFilter.equals(bloomFilter2) : bloomFilter2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public <T> void testAccuracy(String typeName, int numItems, Function1<Random, T> itemGen, ClassTag<T> evidence$1) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"accuracy - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, numItems, itemGen, evidence$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BloomFilterSuite $outer;
            private final int numItems$1;
            public final Function1 itemGen$1;
            private final ClassTag evidence$1$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random r = new Random(37);
                double fpp = 0.05;
                int numInsertion = this.numItems$1 / 10;
                Object allItems = Array$.MODULE$.fill(this.numItems$1, (Function0)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAccuracy$1 $outer;
                    private final Random r$1;

                    public final T apply() {
                        return (T)this.$outer.itemGen$1.apply((Object)this.r$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, this.evidence$1$1);
                BloomFilter filter = BloomFilter.create((long)numInsertion, (double)fpp);
                Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(allItems).take(numInsertion)).foreach((Function1)new Serializable(this, filter){
                    public static final long serialVersionUID = 0L;
                    private final BloomFilter filter$1;

                    public final boolean apply(Object x$1) {
                        return this.filter$1.put(x$1);
                    }
                    {
                        this.filter$1 = filter$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(allItems).take(numInsertion)).forall((Function1)new Serializable(this, filter){
                    public static final long serialVersionUID = 0L;
                    private final BloomFilter filter$1;

                    public final boolean apply(Object x$1) {
                        return this.filter$1.mightContain(x$1);
                    }
                    {
                        this.filter$1 = filter$1;
                    }
                }), "scala.this.Predef.genericArrayOps[T](scala.this.Predef.genericArrayOps[T](allItems).take(numInsertion)).forall({\n  ((x$1: Any) => filter.mightContain(x$1))\n})", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
                double $org_scalatest_assert_macro_left = filter.expectedFpp() - fpp;
                double $org_scalatest_assert_macro_right = 0.01;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
                int errorCount = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(allItems).drop(numInsertion)).count((Function1)new Serializable(this, filter){
                    public static final long serialVersionUID = 0L;
                    private final BloomFilter filter$1;

                    public final boolean apply(Object x$1) {
                        return this.filter$1.mightContain(x$1);
                    }
                    {
                        this.filter$1 = filter$1;
                    }
                });
                double actualFpp = (double)errorCount / (double)(this.numItems$1 - numInsertion);
                double $org_scalatest_assert_macro_left2 = actualFpp - fpp;
                double $org_scalatest_assert_macro_right2 = 0.01;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
                this.$outer.org$apache$spark$util$sketch$BloomFilterSuite$$checkSerDe(filter);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numItems$1 = numItems$1;
                this.itemGen$1 = itemGen$1;
                this.evidence$1$1 = evidence$1$1;
            }
        }, new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
    }

    public <T> void testMergeInPlace(String typeName, int numItems, Function1<Random, T> itemGen, ClassTag<T> evidence$2) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mergeInPlace - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, numItems, itemGen, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BloomFilterSuite $outer;
            private final int numItems$2;
            public final Function1 itemGen$2;
            private final ClassTag evidence$2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random r = new Random(37);
                Object items1 = Array$.MODULE$.fill(this.numItems$2 / 2, (Function0)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMergeInPlace$1 $outer;
                    private final Random r$2;

                    public final T apply() {
                        return (T)this.$outer.itemGen$2.apply((Object)this.r$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$2 = r$2;
                    }
                }, this.evidence$2$1);
                Object items2 = Array$.MODULE$.fill(this.numItems$2 / 2, (Function0)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMergeInPlace$1 $outer;
                    private final Random r$2;

                    public final T apply() {
                        return (T)this.$outer.itemGen$2.apply((Object)this.r$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$2 = r$2;
                    }
                }, this.evidence$2$1);
                BloomFilter filter1 = BloomFilter.create((long)this.numItems$2);
                Predef$.MODULE$.genericArrayOps(items1).foreach((Function1)new Serializable(this, filter1){
                    public static final long serialVersionUID = 0L;
                    private final BloomFilter filter1$1;

                    public final boolean apply(Object x$1) {
                        return this.filter1$1.put(x$1);
                    }
                    {
                        this.filter1$1 = filter1$1;
                    }
                });
                BloomFilter filter2 = BloomFilter.create((long)this.numItems$2);
                Predef$.MODULE$.genericArrayOps(items2).foreach((Function1)new Serializable(this, filter2){
                    public static final long serialVersionUID = 0L;
                    private final BloomFilter filter2$1;

                    public final boolean apply(Object x$1) {
                        return this.filter2$1.put(x$1);
                    }
                    {
                        this.filter2$1 = filter2$1;
                    }
                });
                filter1.mergeInPlace(filter2);
                double $org_scalatest_assert_macro_left = filter1.expectedFpp() - 0.03;
                double $org_scalatest_assert_macro_right = 0.01;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                Predef$.MODULE$.genericArrayOps(items1).foreach((Function1)new Serializable(this, filter1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMergeInPlace$1 $outer;
                    private final BloomFilter filter1$1;

                    public final Assertion apply(T i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.filter1$1.mightContain(i), "filter1.mightContain(i)", Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$util$sketch$BloomFilterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.filter1$1 = filter1$1;
                    }
                });
                Predef$.MODULE$.genericArrayOps(items2).foreach((Function1)new Serializable(this, filter1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMergeInPlace$1 $outer;
                    private final BloomFilter filter1$1;

                    public final Assertion apply(T i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.filter1$1.mightContain(i), "filter1.mightContain(i)", Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$util$sketch$BloomFilterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.filter1$1 = filter1$1;
                    }
                });
                this.$outer.org$apache$spark$util$sketch$BloomFilterSuite$$checkSerDe(filter1);
            }

            public /* synthetic */ BloomFilterSuite org$apache$spark$util$sketch$BloomFilterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numItems$2 = numItems$2;
                this.itemGen$2 = itemGen$2;
                this.evidence$2$1 = evidence$2$1;
            }
        }, new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    public <T> void testItemType(String typeName, int numItems, Function1<Random, T> itemGen, ClassTag<T> evidence$3) {
        this.testAccuracy(typeName, numItems, itemGen, evidence$3);
        this.testMergeInPlace(typeName, numItems, itemGen, evidence$3);
    }

    public BloomFilterSuite() {
        this.testItemType("Byte", 160, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(Random x$1) {
                return (byte)x$1.nextInt();
            }
        }, (ClassTag)ClassTag$.MODULE$.Byte());
        this.testItemType("Short", 1000, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(Random x$2) {
                return (short)x$2.nextInt();
            }
        }, (ClassTag)ClassTag$.MODULE$.Short());
        this.testItemType("Int", 100000, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Random x$3) {
                return x$3.nextInt();
            }
        }, (ClassTag)ClassTag$.MODULE$.Int());
        this.testItemType("Long", 100000, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Random x$4) {
                return x$4.nextLong();
            }
        }, (ClassTag)ClassTag$.MODULE$.Long());
        this.testItemType("String", 100000, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Random r) {
                return r.nextString(r.nextInt(512));
            }
        }, (ClassTag)ClassTag$.MODULE$.apply(String.class));
        this.test("incompatible merge", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BloomFilterSuite $outer;

            public final IncompatibleMergeException apply() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BloomFilter apply() {
                        return BloomFilter.create((long)1000L).mergeInPlace(null);
                    }
                }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BloomFilter apply() {
                        BloomFilter filter1 = BloomFilter.create((long)1000L, (long)6400L);
                        BloomFilter filter2 = BloomFilter.create((long)1000L, (long)3200L);
                        return filter1.mergeInPlace(filter2);
                    }
                }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                return (IncompatibleMergeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BloomFilter apply() {
                        BloomFilter filter1 = BloomFilter.create((long)1000L, (long)6400L);
                        BloomFilter filter2 = BloomFilter.create((long)2000L, (long)6400L);
                        return filter1.mergeInPlace(filter2);
                    }
                }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }
}

