/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.util.sketch.CountMinSketch;
import org.apache.spark.util.sketch.CountMinSketchSuite$;
import org.apache.spark.util.sketch.CountMinSketchSuite$$anonfun$testMergeInPlace$1$;
import org.apache.spark.util.sketch.IncompatibleMergeException;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u00015\u00111cQ8v]Rl\u0015N\\*lKR\u001c\u0007nU;ji\u0016T!a\u0001\u0003\u0002\rM\\W\r^2i\u0015\t)a!\u0001\u0003vi&d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#)\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005M\u0001\"\u0001\u0003$v]N+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%IaG\u0001\u0010KB\u001cxJ\u001a+pi\u0006d7i\\;oiV\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004E_V\u0014G.\u001a\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002!\u0015\u00048o\u00144U_R\fGnQ8v]R\u0004\u0003bB\u0013\u0001\u0005\u0004%IaG\u0001\u000bG>tg-\u001b3f]\u000e,\u0007BB\u0014\u0001A\u0003%A$A\u0006d_:4\u0017\u000eZ3oG\u0016\u0004\u0003bB\u0015\u0001\u0005\u0004%IAK\u0001\u0005g\u0016,G-F\u0001,!\tiB&\u0003\u0002.=\t\u0019\u0011J\u001c;\t\r=\u0002\u0001\u0015!\u0003,\u0003\u0015\u0019X-\u001a3!\u0011\u0015\t\u0004\u0001\"\u00033\u0003)\u0019\u0007.Z2l'\u0016\u0014H)\u001a\u000b\u0003gY\u0002\"!\b\u001b\n\u0005Ur\"\u0001B+oSRDQa\u0001\u0019A\u0002]\u0002\"\u0001\u0007\u001d\n\u0005e\u0012!AD\"pk:$X*\u001b8TW\u0016$8\r\u001b\u0005\u0006w\u0001!\t\u0001P\u0001\ri\u0016\u001cH/Q2dkJ\f7-_\u000b\u0003{)#\"AP/\u0015\u0005}\u001aFCA\u001aA\u0011\u001d\t%(!AA\u0004\t\u000b!\"\u001a<jI\u0016t7-\u001a\u00132!\r\u0019e\tS\u0007\u0002\t*\u0011QIH\u0001\be\u00164G.Z2u\u0013\t9EI\u0001\u0005DY\u0006\u001c8\u000fV1h!\tI%\n\u0004\u0001\u0005\u000b-S$\u0019\u0001'\u0003\u0003Q\u000b\"!\u0014)\u0011\u0005uq\u0015BA(\u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!H)\n\u0005Is\"aA!os\")AK\u000fa\u0001+\u0006i\u0011\u000e^3n\u000f\u0016tWM]1u_J\u0004B!\b,Y\u0011&\u0011qK\b\u0002\n\rVt7\r^5p]F\u0002\"!W.\u000e\u0003iS!!\u0002\u0010\n\u0005qS&A\u0002*b]\u0012|W\u000eC\u0003_u\u0001\u0007q,\u0001\u0005usB,g*Y7f!\t\u00017M\u0004\u0002\u001eC&\u0011!MH\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c=!)q\r\u0001C\u0001Q\u0006\u0001B/Z:u\u001b\u0016\u0014x-Z%o!2\f7-Z\u000b\u0003SB$\"A[:\u0015\u0005-\fHCA\u001am\u0011\u001dig-!AA\u00049\f!\"\u001a<jI\u0016t7-\u001a\u00133!\r\u0019ei\u001c\t\u0003\u0013B$Qa\u00134C\u00021CQ\u0001\u00164A\u0002I\u0004B!\b,Y_\")aL\u001aa\u0001?\")Q\u000f\u0001C\u0001m\u0006aA/Z:u\u0013R,W\u000eV=qKV\u0011qO \u000b\u0004q\u0006\rACA=\u0000)\t\u0019$\u0010C\u0004|i\u0006\u0005\t9\u0001?\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002D\rv\u0004\"!\u0013@\u0005\u000b-#(\u0019\u0001'\t\rQ#\b\u0019AA\u0001!\u0011ib\u000bW?\t\u000by#\b\u0019A0")
public class CountMinSketchSuite
extends FunSuite {
    private final double org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount;
    private final double org$apache$spark$util$sketch$CountMinSketchSuite$$confidence;
    private final int org$apache$spark$util$sketch$CountMinSketchSuite$$seed;

    public double org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount() {
        return this.org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount;
    }

    public double org$apache$spark$util$sketch$CountMinSketchSuite$$confidence() {
        return this.org$apache$spark$util$sketch$CountMinSketchSuite$$confidence;
    }

    public int org$apache$spark$util$sketch$CountMinSketchSuite$$seed() {
        return this.org$apache$spark$util$sketch$CountMinSketchSuite$$seed;
    }

    public void org$apache$spark$util$sketch$CountMinSketchSuite$$checkSerDe(CountMinSketch sketch) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sketch.writeTo((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        CountMinSketch deserialized = CountMinSketch.readFrom((InputStream)in);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sketch);
        CountMinSketch $org_scalatest_assert_macro_right = deserialized;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
    }

    public <T> void testAccuracy(String typeName, Function1<Random, T> itemGenerator, ClassTag<T> evidence$1) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"accuracy - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, itemGenerator, evidence$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountMinSketchSuite $outer;
            public final Function1 itemGenerator$1;
            private final ClassTag evidence$1$1;

            public final Assertion apply() {
                double probCorrect;
                Random r = new Random(31);
                int numAllItems = 1000000;
                Object allItems = Array$.MODULE$.fill(numAllItems, (Function0)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAccuracy$1 $outer;
                    private final Random r$1;

                    public final T apply() {
                        return (T)this.$outer.itemGenerator$1.apply((Object)this.r$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, this.evidence$1$1);
                int numSamples = numAllItems / 10;
                int[] sampledItemIndices = (int[])Array$.MODULE$.fill(numSamples, (Function0)new Serializable(this, r, numAllItems){
                    public static final long serialVersionUID = 0L;
                    private final Random r$1;
                    private final int numAllItems$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.r$1.nextInt(this.numAllItems$1);
                    }
                    {
                        this.r$1 = r$1;
                        this.numAllItems$1 = numAllItems$1;
                    }
                }, ClassTag$.MODULE$.Int());
                Object sampledItems = Predef$.MODULE$.intArrayOps(sampledItemIndices).map((Function1)Predef$.MODULE$.genericWrapArray(allItems), Array$.MODULE$.canBuildFrom(this.evidence$1$1));
                Map exactFreq = Predef$.MODULE$.genericArrayOps(sampledItems).groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final T apply(T x) {
                        return (T)Predef$.MODULE$.identity(x);
                    }
                }).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Object x$1) {
                        return ScalaRunTime$.MODULE$.array_length(x$1);
                    }
                });
                CountMinSketch sketch = CountMinSketch.create((double)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount(), (double)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$confidence(), (int)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$seed());
                this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$checkSerDe(sketch);
                Predef$.MODULE$.intArrayOps(sampledItemIndices).foreach((Function1)new Serializable(this, allItems, sketch){
                    public static final long serialVersionUID = 0L;
                    private final Object allItems$1;
                    private final CountMinSketch sketch$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.sketch$1.add(ScalaRunTime$.MODULE$.array_apply(this.allItems$1, i));
                    }
                    {
                        this.allItems$1 = allItems$1;
                        this.sketch$1 = sketch$1;
                    }
                });
                this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$checkSerDe(sketch);
                int numErrors = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.genericArrayOps(allItems).map((Function1)new Serializable(this, numAllItems, exactFreq, sketch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testAccuracy$1 $outer;
                    private final int numAllItems$1;
                    private final Map exactFreq$1;
                    private final CountMinSketch sketch$1;

                    public final int apply(T item) {
                        long count = BoxesRunTime.unboxToLong((Object)this.exactFreq$1.getOrElse(item, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }));
                        double ratio = (double)(this.sketch$1.estimateCount(item) - count) / (double)this.numAllItems$1;
                        return ratio > this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount() ? 1 : 0;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numAllItems$1 = numAllItems$1;
                        this.exactFreq$1 = exactFreq$1;
                        this.sketch$1 = sketch$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                double $org_scalatest_assert_macro_left = probCorrect = 1.0 - (double)numErrors / (double)numAllItems;
                double $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$confidence();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Confidence not reached: required ", ", reached ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$confidence()), BoxesRunTime.boxToDouble((double)probCorrect)})), Prettifier$.MODULE$.default(), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            }

            public /* synthetic */ CountMinSketchSuite org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.itemGenerator$1 = itemGenerator$1;
                this.evidence$1$1 = evidence$1$1;
            }
        }, new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public <T> void testMergeInPlace(String typeName, Function1<Random, T> itemGenerator, ClassTag<T> evidence$2) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mergeInPlace - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, itemGenerator, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountMinSketchSuite $outer;
            public final Function1 itemGenerator$2;
            private final ClassTag evidence$2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random r = new Random(31);
                int numToMerge = 5;
                int numItemsPerSketch = 100000;
                Object[] perSketchItems = Array$.MODULE$.fill(numToMerge, numItemsPerSketch, (Function0)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMergeInPlace$1 $outer;
                    private final Random r$2;

                    public final T apply() {
                        return (T)this.$outer.itemGenerator$2.apply((Object)this.r$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$2 = r$2;
                    }
                }, this.evidence$2$1);
                CountMinSketch[] sketches = (CountMinSketch[])Predef$.MODULE$.refArrayOps(perSketchItems).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMergeInPlace$1 $outer;

                    /*
                     * WARNING - void declaration
                     */
                    public final CountMinSketch apply(Object items) {
                        void var2_2;
                        CountMinSketch sketch = CountMinSketch.create((double)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount(), (double)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$confidence(), (int)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$seed());
                        this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$checkSerDe(sketch);
                        Predef$.MODULE$.genericArrayOps(items).foreach((Function1)new Serializable(this, sketch){
                            public static final long serialVersionUID = 0L;
                            private final CountMinSketch sketch$2;

                            public final void apply(Object x$1) {
                                this.sketch$2.add(x$1);
                            }
                            {
                                this.sketch$2 = sketch$2;
                            }
                        });
                        this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$checkSerDe(sketch);
                        return var2_2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CountMinSketch.class)));
                CountMinSketch mergedSketch = (CountMinSketch)Predef$.MODULE$.refArrayOps((Object[])sketches).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CountMinSketch apply(CountMinSketch x$2, CountMinSketch x$3) {
                        return x$2.mergeInPlace(x$3);
                    }
                });
                this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$checkSerDe(mergedSketch);
                CountMinSketch expectedSketch = CountMinSketch.create((double)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount(), (double)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$confidence(), (int)this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$seed());
                Predef$.MODULE$.refArrayOps(perSketchItems).foreach((Function1)new Serializable(this, expectedSketch){
                    public static final long serialVersionUID = 0L;
                    public final CountMinSketch expectedSketch$1;

                    public final void apply(Object x$4) {
                        Predef$.MODULE$.genericArrayOps(x$4).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testMergeInPlace$1$$anonfun$apply$mcV$sp$1 $outer;

                            public final void apply(Object x$1) {
                                this.$outer.expectedSketch$1.add(x$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.expectedSketch$1 = expectedSketch$1;
                    }
                });
                Predef$.MODULE$.refArrayOps(perSketchItems).foreach((Function1)new Serializable(this, mergedSketch, expectedSketch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testMergeInPlace$1 $outer;
                    public final CountMinSketch mergedSketch$1;
                    public final CountMinSketch expectedSketch$1;

                    public final void apply(Object x$5) {
                        Predef$.MODULE$.genericArrayOps(x$5).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testMergeInPlace$1$$anonfun$apply$mcV$sp$2 $outer;

                            public final Assertion apply(T item) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.mergedSketch$1.estimateCount(item)));
                                long $org_scalatest_assert_macro_right = this.$outer.expectedSketch$1.estimateCount(item);
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$anonfun$$$outer().org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$testMergeInPlace$1 org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.mergedSketch$1 = mergedSketch$1;
                        this.expectedSketch$1 = expectedSketch$1;
                    }
                });
            }

            public /* synthetic */ CountMinSketchSuite org$apache$spark$util$sketch$CountMinSketchSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.itemGenerator$2 = itemGenerator$2;
                this.evidence$2$1 = evidence$2$1;
            }
        }, new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public <T> void testItemType(String typeName, Function1<Random, T> itemGenerator, ClassTag<T> evidence$3) {
        this.testAccuracy(typeName, itemGenerator, evidence$3);
        this.testMergeInPlace(typeName, itemGenerator, evidence$3);
    }

    public CountMinSketchSuite() {
        this.org$apache$spark$util$sketch$CountMinSketchSuite$$epsOfTotalCount = 0.01;
        this.org$apache$spark$util$sketch$CountMinSketchSuite$$confidence = 0.9;
        this.org$apache$spark$util$sketch$CountMinSketchSuite$$seed = 42;
        this.testItemType("Byte", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(Random x$6) {
                return (byte)x$6.nextInt();
            }
        }, (ClassTag)ClassTag$.MODULE$.Byte());
        this.testItemType("Short", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final short apply(Random x$7) {
                return (short)x$7.nextInt();
            }
        }, (ClassTag)ClassTag$.MODULE$.Short());
        this.testItemType("Int", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Random x$8) {
                return x$8.nextInt();
            }
        }, (ClassTag)ClassTag$.MODULE$.Int());
        this.testItemType("Long", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Random x$9) {
                return x$9.nextLong();
            }
        }, (ClassTag)ClassTag$.MODULE$.Long());
        this.testItemType("String", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Random r) {
                return r.nextString(r.nextInt(20));
            }
        }, (ClassTag)ClassTag$.MODULE$.apply(String.class));
        this.testItemType("Byte array", (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Random r) {
                return r.nextString(r.nextInt(60)).getBytes();
            }
        }, (ClassTag)ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        this.test("incompatible merge", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CountMinSketchSuite $outer;

            public final IncompatibleMergeException apply() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CountMinSketch apply() {
                        return CountMinSketch.create((int)10, (int)10, (int)1).mergeInPlace(null);
                    }
                }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CountMinSketch apply() {
                        CountMinSketch sketch1 = CountMinSketch.create((int)10, (int)20, (int)1);
                        CountMinSketch sketch2 = CountMinSketch.create((int)10, (int)20, (int)2);
                        return sketch1.mergeInPlace(sketch2);
                    }
                }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                return (IncompatibleMergeException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CountMinSketch apply() {
                        CountMinSketch sketch1 = CountMinSketch.create((int)10, (int)10, (int)1);
                        CountMinSketch sketch2 = CountMinSketch.create((int)10, (int)20, (int)2);
                        return sketch1.mergeInPlace(sketch2);
                    }
                }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }
}

